/*


    Evolute version 0.7
    Copyright (C) 2010 Antti Vainio

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


*/

//          alustus.cpp

#include <SDL/SDL_image.h>
#include "global.hpp"

//tm piirt latauspalkin latausruutuun
void latausruutu(const short int kerrat) {
     if(fasterloading != 0) return;
     static int vaihe;
     for(int i=kerrat;i>0;i--) {
             //                           vvv   tuo on kuinka montaa kertaa tt funktiota kutsutaan + jotain, aseta mys alpha sopivaksi
             int kohta1 = (643 * vaihe) / 130 + 3;
             int kohta2 = (643 * vaihe) / 130 + 153;
             if(kohta1 < 153) kohta1 = 153;
             if(kohta2 > 646) kohta2 = 646;
             if(kohta2 >= kohta1) {
                       //luodaan palkki
                       SDL_Surface *raakalatauspalkki1 = SDL_CreateRGBSurface( SDL_HWSURFACE | SDL_SRCALPHA, kohta2 - kohta1 + 1, 44, 32, 0xff000000,0x00ff0000,0x0000ff00,0x000000ff);
                       Uint32 latauspalkki1vari = SDL_MapRGB(raakalatauspalkki1->format, 255, 255, 0);
                       SDL_FillRect(raakalatauspalkki1, NULL, latauspalkki1vari);
                       SDL_Surface *latauspalkki1 = optimoi(raakalatauspalkki1);
                       SDL_SetAlpha(latauspalkki1, SDL_SRCALPHA, 10);
                       //piirretn palkki
                       piirrakuva2(latauspalkki1, kohta1, 353);
                       SDL_FreeSurface(latauspalkki1);
                       SDL_Flip(ruutu);
             }
             vaihe++;
             //hoidetaan tapahtumat
             SDL_Event tapahtuma;
             while (SDL_PollEvent (&tapahtuma)) { }
     }
     if(kerrat == -1) {
               piirrafloatluku(vaihe, 700, 520);
     }
}

//ladataan png ilman alphaa
SDL_Surface *lataapng(const char *nimi) {
       //ladataan kuva
       if (SDL_Surface *tmp = IMG_Load(nimi)) {
                       //optimoidaan
                       if (SDL_Surface *opti = SDL_DisplayFormat(tmp)) {
                                       SDL_FreeSurface(tmp);
                                       tmp = opti;
                       }
                       else {
                                       sprintf(viesti, "%s", SDL_GetError ());
                                       naytavirhe(viesti);
                       }
       return tmp;
       }
       else { //virhe!
                       sprintf(viesti, "%s", SDL_GetError ());
                       naytavirhe(viesti);
                       return 0;
       }
}

//ladataan png alphan kanssa
SDL_Surface *lataapngalpha(const char *nimi) {
       //ladataan kuva
       if (SDL_Surface *tmp = IMG_Load(nimi)) {
                       //optimoidaan
                       if (SDL_Surface *opti = SDL_DisplayFormatAlpha(tmp)) {
                                       SDL_FreeSurface(tmp);
                                       tmp = opti;
                       }
                       else {
                                       sprintf(viesti, "%s", SDL_GetError ());
                                       naytavirhe(viesti);
                       }
       return tmp;
       }
       else { //virhe!
                       sprintf(viesti, "%s", SDL_GetError ());
                       naytavirhe(viesti);
                       return 0;
       }
}

//optimoidaan pinta, jossa ei ole alphaa
//tm funktio vapauttaa annetun pinnan, joten sit ei en tarvitse (saa) erikseen vapauttaa
SDL_Surface *optimoi(SDL_Surface *pinta) {
       //optimoidaan
       if (SDL_Surface *opti = SDL_DisplayFormat(pinta)) {
                       SDL_FreeSurface(pinta);
                       pinta = opti;
       }
       else {
                       sprintf(viesti, "%s", SDL_GetError ());
                       naytavirhe(viesti);
       }
       return pinta;
}

//optimoidaan pinta, jossa on alpha
//tm funktio vapauttaa annetun pinnan, joten sit ei en tarvitse (saa) erikseen vapauttaa
SDL_Surface *optimoialpha(SDL_Surface *pinta) {
       //optimoidaan
       if (SDL_Surface *opti = SDL_DisplayFormatAlpha(pinta)) {
                       SDL_FreeSurface(pinta);
                       pinta = opti;
       }
       else {
                       sprintf(viesti, "%s", SDL_GetError ());
                       naytavirhe(viesti);
       }
       return pinta;
}

//ladataan musiikkia
Mix_Music *lataamusiikki(const char *nimi) {
       //ladataan musiikki
       if (Mix_Music *tmp = Mix_LoadMUS(nimi)) {
                       return tmp;
       }
       else { //virhe!
                       sprintf(viesti, "%s", Mix_GetError());
                       naytavirhe(viesti);
                       return 0;
       }
}

//ladataan nt
Mix_Chunk *lataaaani(const char *nimi) {
       //ladataan aani
       if (Mix_Chunk *tmp = Mix_LoadWAV(nimi)) {
                       return tmp;
       }
       else { //virhe!
                       sprintf(viesti, "%s\nCouldn't open %s", Mix_GetError(), nimi);
                       naytavirhe(viesti);
                       return 0;
       }
}
