/*


    Evolute version 0.7
    Copyright (C) 2010 Antti Vainio

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


*/

//          pelilooppi.cpp

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "global.hpp"
#include "pelilooppi.hpp"

//partikkelit pit mritt tss, jotta ne olisivat globaaleja ja partikkeleiden luontifunktio pystyisi kyttmn niit
const short int partikkelimax = 128;
struct partikkelistr partikkeli[128];
//muut structit voi mritt pelilooppi funktion sisll

void pelilooppi() {
     //Muuttujien esittelyt ja niiden selitykset pelilooppi.hpp:ssa
     
     //alustetaan satunnaisluvut
     time_t siemen;
     time(&siemen);
     srand(siemen);
     
     
                   //ALUSTETAAN MUUTTUJIA
     bool vapautaesc = true;
     bool soitalevelup = false; //soitetaan ni levelup
     bool alasoitalevelup = false; //ei saa soittaa nt levelup; tt kytetn estmn nen soitto uudelleen heti seuraavassa framessa
     
     //muutama pakollinen uudelleen asetus, jotta peli voi pelata monta kertaa perkkin
     pois = false;
     gameover = false;
     voitto = false;
     levurajoitus = 0;
     pisteet = 0;
     tarkkuusarvo = 25;
     crittarkkuus = false;
     tarkammukset = 0;
     tarkosumat = 0;
     odotus = 60;
     nopeuslaskuri = 10000;
     vahinkolevu = 0;
     vahinkoexpa = 0;
     tarkkuuslevu = 0;
     tarkkuusexpa = 0;
     nopeuslevu = 0;
     nopeusexpa = 0;
     hakeutuvuuslevu = 0;
     hakeutuvuusexpa = 0;
     levu = 0;
     expa = 0;
     peliloppu = false;
     peliloppulaskuri = 0;
     bool boss = false;
     bool cheat = false;
     SDL_FreeSurface(tausta);
     tausta = lataapng("images/background.png"); //ladataan uusi puhdas tausta
     
     //onko tutorial?
     if(strcmp(nykyinenkartta, "Tutorial") == 0) ontutorial = true;
     else ontutorial = false;
     tutoriallaskuri = 0;
     
     //strucktit
     struct karttavihu spawn[spawnmax];
     for(i=0;i<spawnmax;i++) { spawn[i].elossa = 0; /*asetetaan kaikki pois kytst*/ spawn[i].aika = 1; }
     
     struct ammusstr ammus[ammusmax];
     for(i=0;i<ammusmax;i++) ammus[i].elossa = 0;
     
     struct explisaysstr explisays[25];
     for(i=0;i<25;i++) explisays[i].elossa = 0;
     
     struct vihustr vihu[vihumax];
     for(i=0;i<vihumax;i++) vihu[i].elossa = 0;
     
     struct vihusplatterstr vihusplatter[vihusplattermax];
     for(i=0;i<vihusplattermax;i++) vihusplatter[i].elossa = 0;
     
     struct vihusplatteremitterstr vihusplatteremitter[vihusplatteremittermax];
     for(i=0;i<vihusplatteremittermax;i++) vihusplatteremitter[i].elossa = 0;
     
     //partikkelit
     for(i=0;i<partikkelimax;i++) partikkeli[i].elossa = 0;
     
     
                   //LADATAAN KARTTA
     //ladataan kartta tiedostosta
     log("Loading map");
     j = 0; //0 = ladataan, 1 = lataus onnistui, 2 = lataus eponnistui
     if(!avaakartta()) { //kartta ei lytynyt
                  j = 2;
     }
     else { //tiedosto avattiin
            if(!j) {
                   fgets(tiedostorivi, 7, tiedosto); //time
                   if(strcmp(tiedostorivi, "time\t\t") != 0) {
                               sprintf(viesti, "Error while loading map.\nDeclaration for 'time' missing or invalid.");
                               naytavirhe(viesti);
                               j = 2;
                   }
                   else {
                               fgets(tiedostorivi, 20, tiedosto); //value for time
                               peliaika = atoi(tiedostorivi) * 40;
                               if(peliaika <= 0) onsurvival = true;
                               else onsurvival = false;
                   }
            }
            if(!j) {
                   fgets(tiedostorivi, 8, tiedosto); //lives
                   if(strcmp(tiedostorivi, "lives\t\t") != 0) {
                               sprintf(viesti, "Error while loading map.\nDeclaration for 'lives' missing or invalid.");
                               naytavirhe(viesti);
                               j = 2;
                   }
                   else {
                               fgets(tiedostorivi, 20, tiedosto); //value for lives
                               elamalkm = atoi(tiedostorivi);
                               if(elamalkm > 0) onelamat = true;
                               else onelamat = false;
                   }
            }
            if(!j) {
                   fgets(tiedostorivi, 9, tiedosto); //damage
                   if(strcmp(tiedostorivi, "damage\t\t") != 0) {
                               sprintf(viesti, "Error while loading map.\nDeclaration for 'damage' missing or invalid.");
                               naytavirhe(viesti);
                               j = 2;
                   }
                   else {
                               fgets(tiedostorivi, 20, tiedosto); //value for damage
                               vahinkolevu = atoi(tiedostorivi);
                               if(vahinkolevu == 1) vahinkoexpa = levuraja[0];
                               else if(vahinkolevu == 2) vahinkoexpa = levuraja[1];
                               else if(vahinkolevu == 3) vahinkoexpa = levuraja[2];
                               else if(vahinkolevu == 4) vahinkoexpa = levuraja[3];
                               else if(vahinkolevu == 5) vahinkoexpa = levuraja[4];
                               if(vahinkolevu < 0 || vahinkolevu > 5) {
                                          sprintf(viesti, "Error while loading map.\nValue for 'damage' must be an integer from 0 to 5.");
                                          naytavirhe(viesti);
                                          j = 2;
                               }
                   }
            }
            if(!j) {
                   fgets(tiedostorivi, 10, tiedosto); //accuracy
                   if(strcmp(tiedostorivi, "accuracy\t") != 0) {
                               sprintf(viesti, "Error while loading map.\nDeclaration for 'accuracy' missing or invalid.");
                               naytavirhe(viesti);
                               j = 2;
                   }
                   else {
                               fgets(tiedostorivi, 20, tiedosto); //value for accuracy
                               tarkkuuslevu = atoi(tiedostorivi);
                               if(tarkkuuslevu == 1) tarkkuusexpa = levuraja[0];
                               else if(tarkkuuslevu == 2) tarkkuusexpa = levuraja[1];
                               else if(tarkkuuslevu == 3) tarkkuusexpa = levuraja[2];
                               else if(tarkkuuslevu == 4) tarkkuusexpa = levuraja[3];
                               else if(tarkkuuslevu == 5) tarkkuusexpa = levuraja[4];
                               if(tarkkuuslevu < 0 || tarkkuuslevu > 5) {
                                          sprintf(viesti, "Error while loading map.\nValue for 'accuracy' must be an integer from 0 to 5.");
                                          naytavirhe(viesti);
                                          j = 2;
                               }
                   }
            }
            if(!j) {
                   fgets(tiedostorivi, 8, tiedosto); //speed
                   if(strcmp(tiedostorivi, "speed\t\t") != 0) {
                               sprintf(viesti, "Error while loading map.\nDeclaration for 'speed' missing or invalid.");
                               naytavirhe(viesti);
                               j = 2;
                   }
                   else {
                               fgets(tiedostorivi, 20, tiedosto); //value for speed
                               nopeuslevu = atoi(tiedostorivi);
                               if(nopeuslevu == 1) nopeusexpa = levuraja[0];
                               else if(nopeuslevu == 2) nopeusexpa = levuraja[1];
                               else if(nopeuslevu == 3) nopeusexpa = levuraja[2];
                               else if(nopeuslevu == 4) nopeusexpa = levuraja[3];
                               else if(nopeuslevu == 5) nopeusexpa = levuraja[4];
                               if(nopeuslevu < 0 || nopeuslevu > 5) {
                                          sprintf(viesti, "Error while loading map.\nValue for 'speed' must be an integer from 0 to 5.");
                                          naytavirhe(viesti);
                                          j = 2;
                               }
                   }
            }
            if(!j) {
                   fgets(tiedostorivi, 9, tiedosto); //homing
                   if(strcmp(tiedostorivi, "homing\t\t") != 0) {
                               sprintf(viesti, "Error while loading map.\nDeclaration for 'homing' missing or invalid.");
                               naytavirhe(viesti);
                               j = 2;
                   }
                   else {
                               fgets(tiedostorivi, 20, tiedosto); //value for homing
                               hakeutuvuuslevu = atoi(tiedostorivi);
                               if(hakeutuvuuslevu == 1) hakeutuvuusexpa = levuraja[0];
                               else if(hakeutuvuuslevu == 2) hakeutuvuusexpa = levuraja[1];
                               else if(hakeutuvuuslevu == 3) hakeutuvuusexpa = levuraja[2];
                               else if(hakeutuvuuslevu == 4) hakeutuvuusexpa = levuraja[3];
                               else if(hakeutuvuuslevu == 5) hakeutuvuusexpa = levuraja[4];
                               if(hakeutuvuuslevu < 0 || hakeutuvuuslevu > 5) {
                                          sprintf(viesti, "Error while loading map.\nValue for 'homing' must be an integer from 0 to 5.");
                                          naytavirhe(viesti);
                                          j = 2;
                               }
                   }
            }
            if(!j) {
                   fgets(tiedostorivi, 8, tiedosto); //level
                   if(strcmp(tiedostorivi, "level\t\t") != 0) {
                               sprintf(viesti, "Error while loading map.\nDeclaration for 'level' missing or invalid.");
                               naytavirhe(viesti);
                               j = 2;
                   }
                   else {
                               fgets(tiedostorivi, 20, tiedosto); //value for level
                               levu = atoi(tiedostorivi);
                               if(levu == 1) expa = peruslevuraja[0];
                               else if(levu == 2) expa = peruslevuraja[1];
                               else if(levu == 3) expa = peruslevuraja[2];
                               else if(levu == 4) expa = peruslevuraja[3];
                               else if(levu == 5) expa = peruslevuraja[4];
                               else if(levu == 6) expa = peruslevuraja[5];
                               else if(levu == 7) expa = peruslevuraja[6];
                               else if(levu == 8) expa = peruslevuraja[7];
                               else if(levu == 9) expa = peruslevuraja[8];
                               else if(levu == -1) {
                                          expa = vahinkoexpa + tarkkuusexpa + nopeusexpa + hakeutuvuusexpa;
                                          if(expa > peruslevuraja[8]) levu = 9;
                                          else if(expa >= peruslevuraja[7]) levu = 8;
                                          else if(expa >= peruslevuraja[6]) levu = 7;
                                          else if(expa >= peruslevuraja[5]) levu = 6;
                                          else if(expa >= peruslevuraja[4]) levu = 5;
                                          else if(expa >= peruslevuraja[3]) levu = 4;
                                          else if(expa >= peruslevuraja[2]) levu = 3;
                                          else if(expa >= peruslevuraja[1]) levu = 2;
                                          else if(expa >= peruslevuraja[0]) levu = 1;
                                          else levu = 0;
                               }
                               if(levu < -1 || levu > 9) {
                                          sprintf(viesti, "Error while loading map.\nValue for 'level' must be an integer from 0 to 9 or -1 for auromatic level.");
                                          naytavirhe(viesti);
                                          j = 2;
                               }
                   }
            }
            fgets(tiedostorivi, 20, tiedosto); //tyhj rivi
                  i = 0;
                  while(!j) {
                            //ladataan vihulaiset
                            fgets(spawn[i].nimi, 99, tiedosto); //spawner:
                            spawn[i].elossa = 1;
                            if(!j) {
                                   fgets(tiedostorivi, 8, tiedosto); //start
                                   if(strcmp(tiedostorivi, "start\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt spawner %i: declaration for 'start' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for start
                                            spawn[i].alku = atoi(tiedostorivi) * 40;
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 6, tiedosto); //end
                                   if(strcmp(tiedostorivi, "end\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt spawner %i: declaration for 'end' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for end
                                            spawn[i].loppu = atoi(tiedostorivi) * 40;
                                            if(spawn[i].loppu < 0) spawn[i].loppu = 1000000;
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 7, tiedosto); //rate
                                   if(strcmp(tiedostorivi, "rate\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt spawner %i: declaration for 'rate' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for rate
                                            if(strstr(tiedostorivi, "boss")) {
                                                                    spawn[i].rate = 1000000;
                                                                    boss = true;
                                                                    peliaika = 1000000;
                                                                    onsurvival = false;
                                            }
                                            else {
                                                spawn[i].rate = atof(tiedostorivi) * 40;
                                                if(spawn[i].rate <= 0) {
                                                           sprintf(viesti, "Error while loading map.\nAt spawner %i: value for 'rate' must be a float larger than 0.", i + 1);
                                                           naytavirhe(viesti);
                                                           j = 2;
                                                }
                                            }
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 12, tiedosto); //raterandom
                                   if(strcmp(tiedostorivi, "raterandom\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt spawner %i: declaration for 'raterandom' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for raterandom
                                            spawn[i].raterandom = atof(tiedostorivi);
                                            if(spawn[i].raterandom < 0) {
                                                       sprintf(viesti, "Error while loading map.\nAt spawner %i: value for 'raterandom' must be a float larger than or equal to 0.", i + 1);
                                                       naytavirhe(viesti);
                                                       j = 2;
                                            }
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 10, tiedosto); //minrate
                                   if(strcmp(tiedostorivi, "minrate\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt spawner %i: declaration for 'minrate' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for minrate
                                            spawn[i].minrate = atof(tiedostorivi) * 40;
                                            if(spawn[i].minrate <= 0) {
                                                       sprintf(viesti, "Error while loading map.\nAt spawner %i: value for 'minrate' must be a float larger than 0.", i + 1);
                                                       naytavirhe(viesti);
                                                       j = 2;
                                            }
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 10, tiedosto); //progress
                                   if(strcmp(tiedostorivi, "progress\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt spawner %i: declaration for 'progress' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for progress
                                            spawn[i].vaikeutuminen = atof(tiedostorivi);
                                   }
                            }
                            
                            fgets(tiedostorivi, 99, tiedosto); //enemy:
                            if(!j) {
                                   fgets(tiedostorivi, 7, tiedosto); //type
                                   if(strcmp(tiedostorivi, "type\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt enemy %i: declaration for 'type' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for type
                                            spawn[i].tyyppi = atoi(tiedostorivi);
                                            if(spawn[i].tyyppi < -1 || spawn[i].tyyppi > 7) {
                                                       sprintf(viesti, "Error while loading map.\nAt enemy %i: value for 'type' must be an integer from 0 to 7 or -1 for auromatic type.", i + 1);
                                                       naytavirhe(viesti);
                                                       j = 2;
                                            }
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 8, tiedosto); //value
                                   if(strcmp(tiedostorivi, "value\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt enemy %i: declaration for 'value' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for value
                                            spawn[i].arvo = atoi(tiedostorivi);
                                            if(spawn[i].arvo < 0) {
                                                       sprintf(viesti, "Error while loading map.\nAt enemy %i: value for 'value' must be an integer larger than or equal to 0.", i + 1);
                                                       naytavirhe(viesti);
                                                       j = 2;
                                            }
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 8, tiedosto); //speed
                                   if(strcmp(tiedostorivi, "speed\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt enemy %i: declaration for 'speed' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for speed
                                            spawn[i].nopeus = atof(tiedostorivi);
                                            if(spawn[i].nopeus <= 0) {
                                                       sprintf(viesti, "Error while loading map.\nAt enemy %i: value for 'speed' must be a float larger than 0.", i + 1);
                                                       naytavirhe(viesti);
                                                       j = 2;
                                            }
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 13, tiedosto); //speedrandom
                                   if(strcmp(tiedostorivi, "speedrandom\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt enemy %i: declaration for 'speedrandom' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for speedrandom
                                            spawn[i].nopeusrandom = atof(tiedostorivi);
                                            if(spawn[i].nopeusrandom < 0) {
                                                       sprintf(viesti, "Error while loading map.\nAt enemy %i: value for 'speedrandom' must be a float larger than or equal to 0.", i + 1);
                                                       naytavirhe(viesti);
                                                       j = 2;
                                            }
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 7, tiedosto); //size
                                   if(strcmp(tiedostorivi, "size\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt enemy %i: declaration for 'size' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for size
                                            spawn[i].koko = atoi(tiedostorivi);
                                            if(spawn[i].koko < 1 || spawn[i].koko > 5) {
                                                       sprintf(viesti, "Error while loading map.\nAt enemy %i: value for 'size' must be an integer from 1 to 5.", i + 1);
                                                       naytavirhe(viesti);
                                                       j = 2;
                                            }
                                   }
                            }
                            if(!j) {
                                   fgets(tiedostorivi, 9, tiedosto); //health
                                   if(strcmp(tiedostorivi, "health\t\t") != 0) {
                                            sprintf(viesti, "Error while loading map.\nAt enemy %i: declaration for 'health' missing or invalid.", i + 1);
                                            naytavirhe(viesti);
                                            j = 2;
                                   }
                                   else {
                                            fgets(tiedostorivi, 20, tiedosto); //value for health
                                            spawn[i].energia = atoi(tiedostorivi);
                                            if(spawn[i].energia < 1) {
                                                       sprintf(viesti, "Error while loading map.\nAt enemy %i: value for 'health' must be an integer larger than 0.", i + 1);
                                                       naytavirhe(viesti);
                                                       j = 2;
                                            }
                                   }
                            }
                            
                            if(!j) {
                                   fgets(tiedostorivi, 4, tiedosto); //tyhj rivi tai end
                                   if(strcmp(tiedostorivi, "end") == 0) j = 1; //ollaanko nyt lopussa?
                                   else i++; //ei olla lopussa
                            }
                  //whilen sulku
                  }
                  fclose(tiedosto);
     }
     if(j == 2) pois = true; //tuli virhe, ei mennkkn peliin
     else {
          sprintf(viesti, "%s loaded; %i different spawners", nykyinenkartta, i + 1);
          log(viesti);
          //Musiikkia!
          soitamusiikki(pelimusiikki, -1);
     }
     
     //luodaan satunnainen alkutervehdys
     char tervehdys[50];
     if(boss) i = 6;
     else {
          i = rand() % 5;
          if(rand() % 50 == 0) i = 5;
     }
     switch(i) {
               case 0:
                    sprintf(tervehdys, "%s", "This is it!");
                    break;
               case 1:
                    sprintf(tervehdys, "%s", "Here we go!");
                    break;
               case 2:
                    sprintf(tervehdys, "%s", "Are you ready?");
                    break;
               case 3:
                    sprintf(tervehdys, "%s", "Get ready!");
                    break;
               case 4:
                    sprintf(tervehdys, "%s", "Here they come!");
                    break;
               case 5:
                    sprintf(tervehdys, "%s", "secret"); //mik tm on :O
                    break;
               case 6:
                    sprintf(tervehdys, "%s", "boss"); //pkill omansa
                    break;
               default:
                    sprintf(tervehdys, "%s", "error"); //tm ei _toivottavasti_ koskaan ny :P
                    break;
     }
     if(ontutorial) sprintf(tervehdys, "%s", "tutorial");
     
     aikalaskuri = -1;
     
     
     
//------------------------------
//                              TST ALKAA PELIN LOPULLINEN LOOPPI                 ------------------------------
//------------------------------


     while (!pois) {
     //tm loopataan kokonaisuudessaan joka frame, kun ollaan peliss
     alkuaika = SDL_GetTicks();
     aikalaskuri++;
     peliaika--;
     if(peliloppu) peliloppulaskuri++;
     if(peliloppulaskuri == 160) Mix_FadeOutMusic(2000);
     levutekstilaskuri++;
     
     if(aikalaskuri == 1) tarkkuusarvo = 25; //jostain ksittmttmst syyst tt tarvitaan joskus tai tarkkuus ei toimi ollenkaan
     
     //miss hiiri ja mit painetaan nppimistll
     SDL_GetMouseState(&hiirix,&hiiriy);
     pelaajaninputit = SDL_GetKeyState(NULL);
     hiirikohta.x = hiirix;
     hiirikohta.y = hiiriy;
     /*SDL_PumpEvents();*/ //tarviiko tt oikeasti tss?
     if(SDL_GetMouseState(NULL, NULL)&SDL_BUTTON(1)) hiiriekanappi = true;
     else hiiriekanappi = false;
     
     if(mapdebugkeys != 0) {
                     if(pelaajaninputit[SDLK_q]) framerate = 200; //debug - pelin nopeuden vaihto lennosta
                     if(pelaajaninputit[SDLK_w]) framerate = 25;
                     if(pelaajaninputit[SDLK_e]) framerate = 18;
                     if(pelaajaninputit[SDLK_r]) framerate = 10;
                     if(pelaajaninputit[SDLK_t]) framerate = 2;
                     if(pelaajaninputit[SDLK_y]) cheat = true;
                     if(pelaajaninputit[SDLK_u]) cheat = false;
     }
     
     //testataan onko hiiri nappien pll
     if(hiirix > 750 && hiiriy < 22) valinta = 1;
     else valinta = 0;
     //testataan painettiinko hiiri napin pll
     if(valinta != 0 && !hiiriprewekanappi && hiiriekanappi) {
                 meneescmenuun = true;
                 piirtokohta = tempruutuesc; //piirretnkin kaikki tempruudulle, kun mennn escmenuun
                 soitaaani(nappi2); //ni
     }
     //nappinet
     else if(valinta != prewvalinta && valinta != 0) soitaaani(nappion);
     
     //ESC-nappi
     if(!vapautaesc && !pelaajaninputit[SDLK_ESCAPE]) vapautaesc = true; //vapautetaan esc-nappi
     if(pelaajaninputit[SDLK_ESCAPE] && vapautaesc && !menekauppaan) {
                 soitaaani(nappi2); //ni
                 meneescmenuun = true;
                 piirtokohta = tempruutuesc; //piirretnkin kaikki tempruudulle, kun mennn escmenuun
     }
     
     //P(ause)-nappi
     if(pelaajaninputit[SDLK_p]) {
                 soitaaani(nappi2); //ni
                 meneescmenuun = true;
                 piirtokohta = tempruutuesc; //piirretnkin kaikki tempruudulle, kun mennn escmenuun
     }
     
     //menetetn focus
     focus = SDL_GetAppState();
     if(focus & SDL_APPINPUTFOCUS) {}
     else {
                 meneescmenuun = true;
                 piirtokohta = tempruutuesc; //piirretnkin kaikki tempruudulle, kun mennn escmenuun
     }
     
     
     
              //           LASKETAAN KAIKKI
              
              //Ammus
     //luodaan ammus
     //tm on jo nyt tss, jotta saadaan ktevsti listty ampumisen eptarkkuus ennen muita tarkkuuteen vaikuttavia asioita
     //tmn takia joudutaan kuitenkin kyttmn edellisen framen tarkkuusarvoja, mutta se tuskin on suuri onglema
     if(hiiriekanappi && odotus <= 0 && !meneescmenuun) { //ei ammuta, jos mennn esc-menuun
                 i = 0; j = 0;
                 while(!j && i < ammusmax) {
                          if(ammus[i].elossa == 0 || ammus[i].elossa == 2) {
                                     ammus[i].elossa = 1;
                                     ammuseptarksuunta = rand() % 359;
                                     if(crittarkkuus == true) {
                                                     ammuseptarkmatka = 0;
                                                     ammus[i].crit = true;
                                                     soitaaani(ampu2); //ni
                                     }
                                     else {
                                                     ammuseptarkmatka = rand() % tahtainkoko;
                                                     ammus[i].crit = false;
                                                     soitaaani(ampu); //ni
                                     }
                                     ammus[i].x = 400 + cos(tarkhiirikulma) * 30;
                                     ammus[i].y = 550 - sin(tarkhiirikulma) * 30;
                                     //tss kohdassa lopussa on sqrt(ammuseptarkmatka * tahtainkoko),
                                     //mutta siin voisi olla mys pelkk ammuseptarkmatka
                                     //nyt ammusepatarkmatkan kasvaessa syntyy nouseva sqrt(x) kyr
                                     //eptarkkuuden mr tulee nyt siis olemaan suurempi
                                     //tm siksi, ett eptarkkuutta olisi muuten liian vhn, koska sen suunta voi lievent sit
                                     ammus[i].suuntakohtax = tarkhiirix + cos(ammuseptarksuunta / 180 * PI) * sqrt(ammuseptarkmatka * tahtainkoko);
                                     ammus[i].suuntakohtay = tarkhiiriy - sin(ammuseptarksuunta / 180 * PI) * sqrt(ammuseptarkmatka * tahtainkoko);
                                     if(ammus[i].suuntakohtay > 549) ammus[i].suuntakohtay = 549; //ilman tt tulee bugela ammuksen lhtsuunnan kanssa, koska se ei voi lhte alaspin
                                     ammus[i].suunta = laskekulma(400, 550, ammus[i].suuntakohtax, ammus[i].suuntakohtay);
                                     ammus[i].efekti = 16;
                                     ammus[i].tapot = 0;
                                     odotus = odotus + odotusmuutos;
                                     crittarkkuus = false;
                                     if(ammus[i].suunta < 0.1) ammus[i].suunta = 0.1;              //tm on estmn trmystarkistuksessa tapahtuvia bugela, kun panos menee vaakatasossa - tm sama on mys panoksen hakeutuvuus loopissa
                                     if(ammus[i].suunta > PI - 0.1) ammus[i].suunta = PI - 0.1;    //bugit tapahtuvat usein silloin, kun hakeutuvuuslevulla 5 critpanos menee niin vaakatasossa kuin mahdollista
                                     tarkkuusarvo = tarkkuusarvo + 5; //muokkaa tt lukua sopivaksi - eptarkkuuden lisys ammuttaessa
                                     tykkitulilaskuri = 9;
                                     tykkitulikuva = rand() % 2;
                                     tykkitulisuunta = tarkhiirikulma;
                                     j = 1;
                          }
                 i++;
                 }
     }
     
              //Tarkkuus
     //asetetaan thtin omaan kohtaansa, niin ett se ei mene peliareenan ulkopuolelle
     tarkhiirix = hiirix;
     tarkhiiriy = hiiriy;
     if(tarkhiirix < 150) tarkhiirix = 150;
     if(tarkhiirix > 650) tarkhiirix = 650;
     if(tarkhiiriy > 550) tarkhiiriy = 550;
     //lasketaan hiiren kulma - tm joudutaan laskemaan jo tss, jotta saataisiin laskettua hiiren liikkeen vaikutus
     tarkhiirikulma = laskekulma(400,550,tarkhiirix,tarkhiiriy);
     //lasketaan hiiten etisyys
     tarkhiirietaisyys = laskeetaisyys(400,550,tarkhiirix,tarkhiiriy);
     //listn ammuksen eptarkkuus (tuli jo aikaisemmin) - listn hiiren liike - kerrotaan kertoimella - testataan maximi
     if(crittarkkuus == false) {
                     //                                    vvvv  muokkaa tuota kerrointa sopivaksi - hiiren liikkeen vaikutus
                     if(tarkhiiriprewkulma > tarkhiirikulma)
                              tarkkuusarvo = tarkkuusarvo + 20 * (tarkhiiriprewkulma - tarkhiirikulma);
                     else
                              tarkkuusarvo = tarkkuusarvo + 20 * (tarkhiirikulma - tarkhiiriprewkulma);
                     //tm oli vanha tapa, jossa laskettiin hiiren tekemn matkan perusteella
                     //nyt lasketaan tykin kulman muuttumisen perusteella
                     /*tarkkuusarvo = tarkkuusarvo + 0.1 * laskeetaisyys(tarkhiirix, tarkhiiriy, tarkhiiriprewx, tarkhiiriprewy);*/
                     if(tarkkuuslevu == 5)
                              crittarkkuus = true;
                     else if(tarkkuuslevu == 4)
                              tarkkuusarvo = tarkkuusarvo * 0.965;
                     else
                              tarkkuusarvo = tarkkuusarvo * (0.99 - 0.005 * tarkkuuslevu);
                                     
                     if(tarkkuuslevu == 4 || tarkkuuslevu == 5) {
                              if(tarkkuusarvo > 14)
                                     tarkkuusarvo = 14; }
                     else if(tarkkuusarvo > 25 - 2.5 * tarkkuuslevu)
                              tarkkuusarvo = 25 - 2.5 * tarkkuuslevu;
     }
     if(tarkkuusarvo < 1.5) crittarkkuus = true;
     if(crittarkkuus) {
                     if(tarkkuusarvo > 0) tarkkuusarvo = tarkkuusarvo * 0.9 - 0.02;
                     if(tarkkuusarvo < 0) { tarkkuusarvo = 0; crittahtainkuva = 0; }
     }
     crittahtainkuva++;
     //lasketaan tarkkuuskulma                                 vvv muokkaa tuota kerrointa sopivaksi - lopullinen tarkkuus
     tarkviivavx = 400 + cos(tarkhiirikulma + tarkkuusarvo * 0.013) * 610;
     tarkviivavy = 550 - sin(tarkhiirikulma + tarkkuusarvo * 0.013) * 610;
     tarkviivaox = 400 + cos(tarkhiirikulma - tarkkuusarvo * 0.013) * 610;
     tarkviivaoy = 550 - sin(tarkhiirikulma - tarkkuusarvo * 0.013) * 610;
     //lasketaan pallon koko
     tahtainkoko = int(round(tarkhiirietaisyys * tan(tarkkuusarvo * 0.013 * (2.0 / 3.0))));
     if(tahtainkoko > 109) tahtainkoko = 109;
     if(tahtainkoko == 0) tahtainkoko = 1;
     
                  //Nopeus
     if(odotus > 0) odotus--;
     if(nopeuslaskuri > 1) nopeuslaskuri--;
     tykkitulilaskuri--;
     
                  //Ammus
     //lasketaan ammukset
     i = 0; j = 0;
     while(!j && i < ammusmax) {
              if(ammus[i].elossa == 1) {
                         if(ammus[i].x < 140 || ammus[i].x > 660 || ammus[i].y < -10 || ammus[i].y> 600) {
                                    ammus[i].elossa = 2;
                                    if(ammus[i].tapot == 0) tarkammukset++;
                         }
                         ammus[i].x = ammus[i].x + cos(ammus[i].suunta) * 15; //tss ammusten nopeus
                         ammus[i].y = ammus[i].y - sin(ammus[i].suunta) * 15; //tss ammusten nopeus
                         ammus[i].efekti--;
                         //luodaan partikkeli, joka lhtee kriittisest panoksesta
                         if(ammus[i].crit && aikalaskuri % 2 == 0) {
                                         l = 0; k = 0;
                                         while(!k && l < partikkelimax) {
                                                  if(partikkeli[l].elossa == 0 || partikkeli[l].elossa == 2) {
                                                                  partikkeli[l].elossa = 1;
                                                                  partikkeli[l].tyyppi = 3;
                                                                  partikkeli[l].x = ammus[i].x;
                                                                  partikkeli[l].y = ammus[i].y;
                                                                  partikkeli[l].nopeus = 1.5;
                                                                  partikkeli[l].kitka = 0.95;
                                                                  partikkeli[l].suunta = rand() % 360;
                                                                  k = 1;
                                                  }
                                                  l++;
                                         }
                         }
              }
              else if(ammus[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }
     
                  //Partikkeli
     //luodaan partikkeli, joka lhtee kriittisest thtimest
     if(tarkkuusarvo == 0 && aikalaskuri % 3 == 0) {
                     i = 0; j = 0;
                     while(!j && i < partikkelimax) {
                              if(partikkeli[i].elossa == 0 || partikkeli[i].elossa == 2) {
                                              partikkeli[i].elossa = 1;
                                              partikkeli[i].tyyppi = 1;
                                              partikkeli[i].x = tarkhiirix;
                                              partikkeli[i].y = tarkhiiriy;
                                              partikkeli[i].nopeus = 1.5;
                                              partikkeli[i].kitka = 0.95;
                                              partikkeli[i].suunta = rand() % 360;
                                              j = 1;
                              }
                              i++;
                     }
     }
     //lasketaan partikkeli
     i = 0; j = 0;
     while(!j && i < partikkelimax) {
              if(partikkeli[i].elossa == 1) {
                         partikkeli[i].nopeus*= partikkeli[i].kitka;
                         partikkeli[i].x = partikkeli[i].x + cos(partikkeli[i].suunta / 180 * PI) * partikkeli[i].nopeus;
                         partikkeli[i].y = partikkeli[i].y - sin(partikkeli[i].suunta / 180 * PI) * partikkeli[i].nopeus;
                         if(partikkeli[i].nopeus < 0.1) {
                                                 partikkeli[i].elossa = 2;
                                                 if(partikkeli[i].tyyppi == 3) piirraanimoitukuvataustaan(partikkeli3, partikkeli[i].x, partikkeli[i].y, 5, 5, 3);
                         }
              }
              else if(partikkeli[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }
     
     short int loppulaskuri = 0; //jos tm saa arvon kaksi, stage loppuu
     if(!onsurvival && peliaika <= 0) loppulaskuri++;
     if(boss && vihu[0].elossa == 2) peliaika = 0;
     //loppulaskuria kasvatetaan viel yhdell, jos kaikki vihut ovat kuolleet
     
                  //Vihulainen
     //luodaan vihulainen
     i = 0;
     while(spawn[i].elossa == 1 && loppulaskuri == 0) { //luodaan uusi vihollinen vain, jos ei ole loppu
                   if(spawn[i].alku < aikalaskuri && aikalaskuri < spawn[i].loppu) {
                              spawn[i].aika--;
                              spawn[i].rate-= spawn[i].vaikeutuminen;
                              if(spawn[i].rate < spawn[i].minrate) spawn[i].rate = spawn[i].minrate;
                              if(spawn[i].aika < 0) {
                                        j = 0; k = 0;
                                        while(!k && j < vihumax) {
                                                 if(vihu[j].elossa == 0 || vihu[j].elossa == 2) {
                                                           vihu[j].elossa = 1;
                                                           sprintf(vihu[j].nimi, "%s", spawn[i].nimi);
                                                           vihu[j].arvo = spawn[i].arvo;
                                                           if(spawn[i].tyyppi == 4) vihu[j].koko = (100 - vihuminkoko) / vihukokokerroin; //asetetaan mustan vihun koko niin, ett sen koko pikseleiss on 100
                                                           else if(spawn[i].tyyppi == 7) vihu[j].koko = (120 - vihuminkoko) / vihukokokerroin; //pkin koko niin pikseleiss on 120
                                                           else if(spawn[i].tyyppi == 5) vihu[j].koko = 4; //asetetaan nopean vihun koko
                                                           else vihu[j].koko = spawn[i].koko;
                                                           vihu[j].x = rand() % 480 + 160;
                                                           vihu[j].y = 0 - ((vihu[j].koko - 1) * vihukokokerroin + vihuminkoko) / 2;
                                                           floati = rand() % 101;
                                                           vihu[j].vihunopeus = spawn[i].nopeus * (1 + spawn[i].nopeusrandom * floati / 10000);
                                                           vihu[j].nopeusy = vihu[j].vihunopeus;
                                                           if(spawn[i].tyyppi == 6) {
                                                                              if(rand() % 2 == 0) vihu[j].nopeusx = float(rand() % 101) / 100.0;
                                                                              else vihu[j].nopeusx = -float(rand() % 101) / 100.0;
                                                           }
                                                           else vihu[j].nopeusx = 0;
                                                           vihu[j].kuvasuunta = rand() % 10;
                                                           vihu[j].vihuenergia = spawn[i].energia;
                                                           vihu[j].energia = spawn[i].energia;
                                                           if(spawn[i].tyyppi == -1) {
                                                                      if(vihu[j].koko == 1) floati = vihu[j].energia / (0.5 * vihu[j].vihunopeus);
                                                                      else floati = vihu[j].energia / ((vihu[j].koko - 1) * vihu[j].vihunopeus);
                                                                      if(floati < 1.5) vihu[j].tyyppi = 1;
                                                                      else if(floati > 5.5) vihu[j].tyyppi = 2;
                                                                      else vihu[j].tyyppi = 0;
                                                           }
                                                           else vihu[j].tyyppi = spawn[i].tyyppi;
                                                           vihu[j].lopussa = false;
                                                           k = 1;
                                                 }
                                                 j++;
                                        }
                                        floati = rand() % 101;
                                        spawn[i].aika+= spawn[i].rate * (1 + spawn[i].raterandom * floati / 10000);
                              }
                   }
                   i++;
     }
     //lasketaan vihulaiset
     i = 0; j = 0;
     bool eivihuja = true; //jos tm pysyy truena, kasvatetaan loppulaskuria
     while(!j && i < vihumax) {
              if(vihu[i].elossa == 1) {
                        eivihuja = false;
                        if(vihu[i].y > 555 - ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko) / 2 && !vihu[i].lopussa) { //game over
                                     if(vihu[i].tyyppi == 4) elamalkm = -1;
                                     else elamalkm--;
                                     if(elamalkm < 0 || !onelamat) {
                                                 gameover = true;
                                                 piirtokohta = tempruutu;
                                                 gameoverkohta = int(round(vihu[i].x));
                                                 if(gameoverkohta < 150) gameoverkohta = 150;
                                                 if(gameoverkohta > 650) gameoverkohta = 650;
                                     }
                                     else vihu[i].lopussa = true;
                        }
                        //varmistetaan, ettei karkaa sivuilta tai mene liian yls
                        if(vihu[i].x < 150 + ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko) / 2) vihu[i].nopeusx+= 0.1;
                        if(vihu[i].x > 650 - ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko) / 2) vihu[i].nopeusx-= 0.1;
                        if(vihu[i].y < 0 - 5 - ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko) / 2) vihu[i].nopeusy+= 0.1;
                        //korjataan nopeutta
                        vihu[i].nopeusx*= 0.95;
                        if(vihu[i].nopeusy < vihu[i].vihunopeus) vihu[i].nopeusy+= 0.02;
                        else if(vihu[i].nopeusy > vihu[i].vihunopeus) vihu[i].nopeusy-= 0.02;
                        //violetin vihun sivuttaisliike
                        if(vihu[i].tyyppi == 6) {
                                          if(rand() % 40 == 0) {
                                                    const float lisays = 0.037 * ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko);
                                                    if(vihu[i].nopeusx < -0.1) vihu[i].nopeusx-= lisays;
                                                    else if(vihu[i].nopeusx > 0.1) vihu[i].nopeusx+= lisays;
                                                    else if(rand() % 2 == 0) vihu[i].nopeusx+= lisays;
                                                    else vihu[i].nopeusx-= lisays;
                                          }
                        }
                        //liikutetaan
                        vihu[i].y+= vihu[i].nopeusy;
                        vihu[i].x+= vihu[i].nopeusx;
                        if(vihu[i].y > 650) vihu[i].elossa = 2;
                        //cheat
                        if(cheat && vihu[i].y > 450) {
                                 vihu[i].elossa = 2;
                                 vahinkoexpa+= 75;
                                 tarkkuusexpa+= 75;
                                 nopeusexpa+= 75;
                                 hakeutuvuusexpa+= 75;
                                 expa+= 300;
                        }
              }
              else if(vihu[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }
     if(eivihuja) loppulaskuri++;
     if(loppulaskuri == 2) peliloppu = true; //stage loppui
     //lasketaan splatterit
     i = 0; j = 0;
     while(!j && i < vihusplattermax) {
              if(vihusplatter[i].elossa == 1) {
                         vihusplatter[i].nopeus*= 0.88;
                         vihusplatter[i].x = vihusplatter[i].x + cos(vihusplatter[i].suunta / 180 * PI) * vihusplatter[i].nopeus;
                         vihusplatter[i].y = vihusplatter[i].y - sin(vihusplatter[i].suunta / 180 * PI) * vihusplatter[i].nopeus;
                         vihusplatter[i].frame--;
                         if(vihusplatter[i].frame < 0) {
                                  vihusplatter[i].elossa = 2;
                                  if(vihusplatter[i].tyyppi == 4) piirrakuvataustaan(splatterkuvamusta[4][int(floor(vihusplatter[i].suunta / 12))], vihusplatter[i].x, vihusplatter[i].y);
                                  else if(vihusplatter[i].tyyppi == 5) piirrakuvataustaan(splatterkuvanopea[4][int(floor(vihusplatter[i].suunta / 12))], vihusplatter[i].x, vihusplatter[i].y);
                                  else if(vihusplatter[i].tyyppi == 6) piirrakuvataustaan(splatterkuva[4][int(vihusplatter[i].koko - 1)][4][int(floor(vihusplatter[i].suunta / 12))], vihusplatter[i].x, vihusplatter[i].y);
                                  else piirrakuvataustaan(splatterkuva[vihusplatter[i].tyyppi][int(vihusplatter[i].koko - 1)][4][int(floor(vihusplatter[i].suunta / 12))], vihusplatter[i].x, vihusplatter[i].y);
                         }
              }
              else if(vihusplatter[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }
     //lasketaan splatteremitterit
     i = 0; k = 0;
     while(!k && i < vihusplatteremittermax) {
              if(vihusplatteremitter[i].elossa == 1) {
                         vihusplatteremitter[i].nopeus*= 0.96;
                         vihusplatteremitter[i].x = vihusplatteremitter[i].x + cos(vihusplatteremitter[i].suunta / 5 * PI) * vihusplatteremitter[i].nopeus;
                         vihusplatteremitter[i].y = vihusplatteremitter[i].y - sin(vihusplatteremitter[i].suunta / 5 * PI) * vihusplatteremitter[i].nopeus;
                         bool luosplatter = false;
                         if(vihusplatteremitter[i].tyyppi == 4 || vihusplatteremitter[i].tyyppi == 5) { //hitaammin mustalla ja nopealla
                                                          if(vihusplatteremitter[i].frame % 4 == 0) luosplatter = true;
                         }
                         else if(vihusplatteremitter[i].frame % 2 == 0) luosplatter = true;
                         if(luosplatter) {
                                j = 0; k = 0;
                                while(!k && j < vihusplattermax) {
                                         //luodaan splatter
                                         if(vihusplatter[j].elossa == 0 || vihusplatter[j].elossa == 2) {
                                                  vihusplatter[j].elossa = 1;
                                                  vihusplatter[j].frame = 24;
                                                  vihusplatter[j].tyyppi = vihusplatteremitter[i].tyyppi;
                                                  vihusplatter[j].koko = vihusplatteremitter[i].koko;
                                                  vihusplatter[j].x = vihusplatteremitter[i].x;
                                                  vihusplatter[j].y = vihusplatteremitter[i].y;
                                                  floati = rand() % 10;
                                                  vihusplatter[j].nopeus = (3 * /*<-lisys*/ 0.055 * floati + 0.5) * sqrt(vihusplatteremitter[i].koko) * 3;
                                                  vihusplatter[j].suunta = rand() % 360;
                                                  k = 1;
                                         }
                                         j++;
                                }
                         }
                         vihusplatteremitter[i].frame--;
                         if(vihusplatteremitter[i].frame < 0 && vihusplatteremitter[i].nopeus < 0.5) { //tuhotaan emitter
                                                         vihusplatteremitter[i].elossa = 2;
                                                         if(vihusplatteremitter[i].tyyppi == 4) piirrakuvataustaan(vihukuollutkuvamusta[int(vihusplatteremitter[i].suunta)], vihusplatteremitter[i].x, vihusplatteremitter[i].y);
                                                         else if(vihusplatteremitter[i].tyyppi == 5) piirrakuvataustaan(vihukuollutkuvanopea[int(vihusplatteremitter[i].suunta)], vihusplatteremitter[i].x, vihusplatteremitter[i].y);
                         }
                         k = 0;
              }
              else if(vihusplatteremitter[i].elossa == 2) k = 0;
              else k = 1;
              i++;
     }
     
                  //Explisysnumero
     for(i=0;i<25;i++) {
              explisays[i].nopeus = explisays[i].nopeus + 0.1;
              if(explisays[i].nopeus > 0) explisays[i].x = explisays[i].x - explisays[i].nopeus;
              if(explisays[i].x < 100) explisays[i].elossa = 0;
     }
     
                  //Trmys ja hakeutuvuus: ammus - vihulainen
     i = 0; /*ammuksen id*/ k = 0;
     while(!k && i < ammusmax) {
              short int tempkohde = -1; //temp - hakeutuvuuden kohde
              float tempetaisyys = 1000000; //tempetisyys
              if(ammus[i].elossa == 1) {
                         j = 0; /*vihun id*/ k = 0;
                         while(!k && j < vihumax && ammus[i].elossa == 1) {
                                  if(vihu[j].elossa == 1) {
                                            //thn trmystestit
                                            //aluksi testataan, kuinka panos on vihulaista
                                            //sitten testataan kuinka lhell vihu on ammuksen vetm suoraa
                                            //k kertoo osuiko
                                            k = 0;
                                            if(laskeetaisyys(ammus[i].x, ammus[i].y, vihu[j].x, vihu[j].y) <= ((vihu[j].koko - 1) * vihukokokerroin + vihuminkoko) / 2 + 5) { //loppuun on listty 5 suurentamaan osuma etisyytt, jotta panokset eivt vahingossakaan voisi menn vihollisesta lpi
                                            //if(vihu[j].y >= ammus[i].y && vihu[j].y < ammus[i].y + sin(ammus[i].suunta) * 20 + 5) { //tm olikin paska tapa
                                                      //pisteen etisyys suorasta
                                                      if(PI - ammus[i].suunta == 0 && abs(int(ceil(ammus[i].x - vihu[j].x))) <= ((vihu[j].koko - 1) * vihukokokerroin + vihuminkoko) / 2) //tm on poikkeustaptaus sille, ett tulee tan(PI / 2)
                                                                    k = 1;
                                                      else if(abs(int(ceil((tan(PI - ammus[i].suunta) * (ammus[i].x - vihu[j].x) + vihu[j].y - ammus[i].y)/sqrt(tan(PI - ammus[i].suunta) * tan(PI - ammus[i].suunta) + 1)))) <= ((vihu[j].koko - 1) * vihukokokerroin + vihuminkoko) / 2)
                                                                    k = 1;
                                                      if(k == 1) {
                                                                    //Thn trmystapahtumat
                                                                    float tempvihuenu = vihu[j].vihuenergia;
                                                                    int splatterlkm; //kertoo luotavien splatterien lukumrn
                                                                    //satutetaan vihua ja tuhotaan panos
                                                                    if(ammus[i].crit == false) {
                                                                               ammus[i].elossa = 2;
                                                                               vihu[j].energia-= vahinko;
                                                                    }
                                                                    else {
                                                                               if(vihu[j].energia > vahinko * 2) ammus[i].elossa = 2;
                                                                               else if(vihu[j].tyyppi == 3 && vihu[j].koko != 1 && floor(tempvihuenu / 2) > 0) ammus[i].elossa = 2;
                                                                               vihu[j].energia = vihu[j].energia - vahinko * 2;
                                                                               soitaaani(hitzap); //ni
                                                                    }
                                                                    //tarkkuus
                                                                    if(ammus[i].tapot == 0) tarkammukset++;
                                                                    tarkosumat++;
                                                                    if(tarkosumat > tarkammukset) tarkosumat = tarkammukset;
                                                                    ammus[i].tapot++;
                                                                    //asetetaan luotavien splatterien lukumr
                                                                    if(vihu[j].energia <= 0) { //kuollut
                                                                                       if(vihu[j].tyyppi == 3) splatterlkm = 0; //keltainen
                                                                                       else if(vihu[j].tyyppi == 4) splatterlkm = 10; //musta
                                                                                       else if(vihu[j].tyyppi == 5) splatterlkm = 0; //nopea
                                                                                       else splatterlkm = 8;
                                                                    }
                                                                    else splatterlkm = 2; //elossa
                                                                                     soitaaani(hit); //ni
                                                                                     for(int n=0;n<splatterlkm;n++) {
                                                                                                l = 0; k = 0;
                                                                                                while(!k && l < vihusplattermax) {
                                                                                                         //luodaan splattereita
                                                                                                         if(vihusplatter[l].elossa == 0 || vihusplatter[l].elossa == 2) {
                                                                                                               vihusplatter[l].elossa = 1;
                                                                                                               vihusplatter[l].frame = 24;
                                                                                                               if(vihu[j].tyyppi == 7) {
                                                                                                                                 vihusplatter[l].tyyppi = 1;
                                                                                                                                 vihusplatter[l].koko = 5;
                                                                                                               }
                                                                                                               else {
                                                                                                                                 vihusplatter[l].tyyppi = vihu[j].tyyppi;
                                                                                                                                 vihusplatter[l].koko = vihu[j].koko;
                                                                                                               }
                                                                                                               vihusplatter[l].x = vihu[j].x;
                                                                                                               vihusplatter[l].y = vihu[j].y;
                                                                                                               floati = rand() % 10;
                                                                                                               vihusplatter[l].nopeus = (0.055 * floati + 0.5) * sqrt(vihu[j].koko) * 3;
                                                                                                               vihusplatter[l].suunta = rand() % 360;
                                                                                                               k = 1;
                                                                                                         }
                                                                                                         l++;
                                                                                                }
                                                                                       }
                                                                              if(vihu[j].tyyppi == 7) { //pkki
                                                                                       short vihulkm = vahinko * (ammus[i].crit ? 2 : 1);
                                                                                       for(int n=0;n<vihulkm;n++) {
                                                                                               if(rand() % 4 == 0) {
                                                                                                l = 0; k = 0;
                                                                                                while(!k && l < vihumax && !vihu[j].lopussa) {
                                                                                                         //luodaan vihreit vihuja
                                                                                                         if(vihu[l].elossa == 0 || vihu[l].elossa == 2) {
                                                                                                               vihu[l].elossa = 1;
                                                                                                               vihu[l].arvo = 1;
                                                                                                               vihu[l].koko = 2;
                                                                                                               if(rand() % 2 == 0) {
                                                                                                                         vihu[l].x = vihu[j].x + rand() % 10 - 15;
                                                                                                                         vihu[l].y = vihu[j].y + rand() % 10 - 15;
                                                                                                               }
                                                                                                               else {
                                                                                                                         vihu[l].x = vihu[j].x + rand() % 10 + 5;
                                                                                                                         vihu[l].y = vihu[j].y + rand() % 10 + 5;
                                                                                                               }
                                                                                                               vihu[l].vihunopeus = 0.8 + float(rand() % 11) / 50.0;
                                                                                                               vihu[l].nopeusy = 0; vihu[l].nopeusx = 0;
                                                                                                               vihu[l].kuvasuunta = 0;
                                                                                                               vihu[l].vihuenergia = 1;
                                                                                                               vihu[l].energia = 1;
                                                                                                               vihu[l].tyyppi = 1;
                                                                                                               vihu[l].lopussa = false;
                                                                                                               k = 1;
                                                                                                         }
                                                                                                         l++;
                                                                                                }
                                                                                               }
                                                                                       }
                                                                              }
                                                                    //pushback
                                                                    float pushbacknopeus;
                                                                    if(vihu[j].tyyppi == 5) pushbacknopeus = 2.5; //nopea
                                                                    else if(vihu[j].tyyppi == 1) pushbacknopeus = 1.5; //vihre
                                                                    else if(vihu[j].tyyppi == 6) pushbacknopeus = 1.1; //violetti
                                                                    else if(vihu[j].tyyppi == 0 || vihu[j].tyyppi == 3) pushbacknopeus = 0.8; //sininen ja keltainen
                                                                    else pushbacknopeus = 0.3; //punainen
                                                                    if(ammus[i].crit) pushbacknopeus*= 2; //tuplataan
                                                                    if(vihu[j].tyyppi != 4 && vihu[j].tyyppi != 7) { //mustalla ja pkill ei ole pushbackia
                                                                                      vihu[j].nopeusx+= cos(ammus[i].suunta) * pushbacknopeus * 1.5;
                                                                                      vihu[j].nopeusy-= sin(ammus[i].suunta) * pushbacknopeus;
                                                                    }
                                                                    
                                                                    if(vihu[j].energia <= 0) {           //Thn mit ky, jos vihu kuolee
                                                                              if(vihu[j].tyyppi == 4 || vihu[j].tyyppi == 7) soitaaani(splat4); //ni
                                                                              else {
                                                                                   if(rand() % 3 == 0) soitaaani(splat1); //ni
                                                                                   else if(rand() % 2 == 0) soitaaani(splat2); //ni
                                                                                   else soitaaani(splat3); //ni
                                                                              }
                                                                              //piirretn vihun ruumis taustaan
                                                                              if(vihu[j].tyyppi == 6) piirrakuvataustaan(vihukuollutkuva[4][int(vihu[j].koko - 1)][rand() % 10], vihu[j].x, vihu[j].y);
                                                                              else if(vihu[j].tyyppi == 7) piirrakuvataustaan(vihukuollutkuva7, vihu[j].x, vihu[j].y);
                                                                              else if(vihu[j].tyyppi != 4 && vihu[j].tyyppi != 5) piirrakuvataustaan(vihukuollutkuva[vihu[j].tyyppi][int(vihu[j].koko - 1)][rand() % 10], vihu[j].x, vihu[j].y);
                                                                              //luodaanko emitter?
                                                                              if(vihu[j].tyyppi == 3 || vihu[j].tyyppi == 5 || vihu[j].tyyppi == 7) i = 1;
                                                                              else if(vihu[j].tyyppi == 4) i = 3;
                                                                              else i = 0;
                                                                                       for(i=i;i>0;i--) {
                                                                                                l = 0; k = 0;
                                                                                                while(!k && l < vihusplatteremittermax) {
                                                                                                         //luodaan splatteremitter
                                                                                                         if(vihusplatteremitter[l].elossa == 0 || vihusplatteremitter[l].elossa == 2) {
                                                                                                               vihusplatteremitter[l].elossa = 1;
                                                                                                               vihusplatteremitter[l].frame = 40;
                                                                                                               if(vihu[j].tyyppi == 7) {
                                                                                                                                 vihusplatteremitter[l].tyyppi = 1;
                                                                                                                                 vihusplatteremitter[l].koko = 5;
                                                                                                               }
                                                                                                               else {
                                                                                                                                 vihusplatteremitter[l].tyyppi = vihu[j].tyyppi;
                                                                                                                                 vihusplatteremitter[l].koko = vihu[j].koko;
                                                                                                               }
                                                                                                               vihusplatteremitter[l].x = vihu[j].x;
                                                                                                               vihusplatteremitter[l].y = vihu[j].y;
                                                                                                               floati = rand() % 10;
                                                                                                               if(vihu[j].tyyppi == 4 || vihu[j].tyyppi == 5) vihusplatteremitter[l].nopeus = (0.02 * floati + 0.5) * sqrt(vihu[j].koko) * 2;
                                                                                                               else vihusplatteremitter[l].nopeus = 0;
                                                                                                               if(vihu[j].tyyppi == 5) {
                                                                                                                                 vihusplatteremitter[l].suunta = round(laskekulma(0, 0, vihu[j].nopeusx, vihu[j].nopeusy) / PI * 5);
                                                                                                                                 if(vihusplatteremitter[l].suunta > 9) vihusplatteremitter[l].suunta-= 10;
                                                                                                               }
                                                                                                               else vihusplatteremitter[l].suunta = rand() % 10;
                                                                                                               k = 1;
                                                                                                         }
                                                                                                         l++;
                                                                                                }
                                                                                       }
                                                                              if(vihu[j].tyyppi == 3 && vihu[j].koko != 1 && floor(tempvihuenu / 2) > 0) { //keltainen vihu
                                                                                       for(int n=rand()%2+2;n>0;n--) {
                                                                                                l = 0; k = 0;
                                                                                                while(!k && l < vihumax && !vihu[j].lopussa) {
                                                                                                         //luodaan 2 tai 3 keltaista vihollista
                                                                                                         if(vihu[l].elossa == 0 || vihu[l].elossa == 2) {
                                                                                                               if(n == 1) floati = 0; //luodaan ainakin yksi iso
                                                                                                               else floati = rand() % 2; //luodaanko iso vai pieni, 0 = iso, 1 = pieni
                                                                                                               vihu[l].elossa = 1;
                                                                                                               vihu[l].arvo = int(vihu[j].arvo - 1 - floati);
                                                                                                               if(vihu[l].arvo < 0) vihu[l].arvo = 0; //arvo ei olla alle 0
                                                                                                               vihu[l].koko = vihu[j].koko - 1 - floati;
                                                                                                               if(vihu[l].koko < 1) vihu[l].elossa = 2; //ei olekaan elossa
                                                                                                               vihu[l].x = vihu[j].x + rand() % 10 - 5;
                                                                                                               vihu[l].y = vihu[j].y + rand() % 10 - 5;
                                                                                                               vihu[l].vihunopeus = vihu[j].vihunopeus;
                                                                                                               vihu[l].nopeusy = 0; vihu[l].nopeusx = 0;
                                                                                                               vihu[l].kuvasuunta = rand() % 10;
                                                                                                               vihu[l].vihuenergia = int(floor(tempvihuenu / 2) - 2 * floati);
                                                                                                               vihu[l].energia = vihu[l].vihuenergia;
                                                                                                               if(vihu[l].energia < 1) vihu[l].elossa = 2; //ei olekaan elossa
                                                                                                               vihu[l].tyyppi = vihu[j].tyyppi;
                                                                                                               vihu[l].lopussa = false;
                                                                                                               k = 1;
                                                                                                         }
                                                                                                         l++;
                                                                                                }
                                                                                       }
                                                                              }
                                                                              vihu[j].elossa = 2;
                                                                              //lasketaan expat
                                                                              //luodaan samalla expalisysnumerot
                                                                              //lasketaan damaexpa
                                                                              explisays[0].elossa = 1;
                                                                              explisays[0].x = 155;
                                                                              explisays[0].y = 125;
                                                                              explisays[0].nopeus = -6;
                                                                              short int expasumma;
                                                                              float expatulo;
                                                                              if(ammus[i].tapot > 1 && ammus[i].crit == true) {
                                                                                   vahinkoexpa = vahinkoexpa + 100;
                                                                                   expasumma = 100;
                                                                                   expatulo = 100;
                                                                                   explisays[0].luku = 100;
                                                                              }
                                                                              else if(ammus[i].crit == true) {
                                                                                   vahinkoexpa = vahinkoexpa + 85;
                                                                                   expasumma = 85;
                                                                                   expatulo = 85;
                                                                                   explisays[0].luku = 85;
                                                                              }
                                                                              else {
                                                                                   vahinkoexpa = vahinkoexpa + 70;
                                                                                   expasumma = 70;
                                                                                   expatulo = 70;
                                                                                   explisays[0].luku = 70;
                                                                              }
                                                                              //lasketaan tarkkuusexpa
                                                                              explisays[1].elossa = 1;
                                                                              explisays[1].x = 155;
                                                                              explisays[1].y = 225;
                                                                              explisays[1].nopeus = -6;
                                                                              k = int(round(tarkosumat / tarkammukset * 100));
                                                                              if(k > 100) {
                                                                                   tarkkuusexpa = tarkkuusexpa + 100;
                                                                                   expasumma+= 100;
                                                                                   expatulo*= 100;
                                                                                   explisays[1].luku = 100;
                                                                              }
                                                                              else if(k < 1) {
                                                                                   tarkkuusexpa++;
                                                                                   expasumma++;
                                                                                   explisays[1].luku = 1;
                                                                              }
                                                                              else {
                                                                                   tarkkuusexpa = tarkkuusexpa + k;
                                                                                   expasumma+= k;
                                                                                   expatulo*= k;
                                                                                   explisays[1].luku = k;
                                                                              }
                                                                              //lasketaan nopeusexpa
                                                                              explisays[2].elossa = 1;
                                                                              explisays[2].x = 155;
                                                                              explisays[2].y = 325;
                                                                              explisays[2].nopeus = -6;
                                                                              if(nopeuslaskuri > 100) {
                                                                                   nopeusexpa = nopeusexpa + 100;
                                                                                   expasumma+= 100;
                                                                                   expatulo*= 100;
                                                                                   explisays[2].luku = 100;
                                                                              }
                                                                              else {
                                                                                   nopeusexpa = nopeusexpa + nopeuslaskuri;
                                                                                   expasumma+= nopeuslaskuri;
                                                                                   expatulo*= nopeuslaskuri;
                                                                                   explisays[2].luku = nopeuslaskuri;
                                                                              }
                                                                              nopeuslaskuri = 105 + int(round(odotusmuutos * 1.2));
                                                                              //lasketaan hakeutuvuusexpa
                                                                              explisays[3].elossa = 1;
                                                                              explisays[3].x = 155;
                                                                              explisays[3].y = 425;
                                                                              explisays[3].nopeus = -6;
                                                                              k = int(round((450 /*<- suurenna tuota lukua, niin alue siirtyy alemmaksi*/ - vihu[j].y) / 4));
                                                                              if(k > 100) {
                                                                                   hakeutuvuusexpa = hakeutuvuusexpa + 100;
                                                                                   expasumma+= 100;
                                                                                   expatulo*= 100;
                                                                                   explisays[3].luku = 100;
                                                                              }
                                                                              else if(k <= 0) {
                                                                                   hakeutuvuusexpa++;
                                                                                   expasumma++;
                                                                                   explisays[3].luku = 1;
                                                                              }
                                                                              else {
                                                                                   hakeutuvuusexpa = hakeutuvuusexpa + k;
                                                                                   expasumma+= k;
                                                                                   expatulo*= k;
                                                                                   explisays[3].luku = k;
                                                                              }
                                                                              //lasketaan perusexpa
                                                                              explisays[4].elossa = 1;
                                                                              explisays[4].x = 155;
                                                                              explisays[4].y = 525;
                                                                              explisays[4].nopeus = -6;
                                                                              expa = expa + expasumma;
                                                                              explisays[4].luku = expasumma;
                                                                              //lasketaan pisteet
                                                                              pisteet+= int(round(sqrt(expatulo) / 10) * vihu[j].arvo);
                                                                    }
                                                      }
                                            }
                                            k = 0;
                                            //thn hakeutuvuustesti
                                            //valitaan kohde, joka on mahdollisimman suoraan edess
                                            //tm mys vhent mukavasti sit tilannetta, ett sattuu trmystarkistusbugeja ammuksen menness lhes vaakatasossa
                                                    //1000 kerroin on listty, jotta saataisiin tarkempi likiarvo inttii
                                                    //int tarvitaan, jotta voidaan ottaa abs
                                            floati = abs(int(round(1000 * (laskekulma(ammus[i].x, ammus[i].y, vihu[j].x, vihu[j].y) - ammus[i].suunta))));
                                            if(floati < tempetaisyys) {
                                                      tempkohde = j; //j on tmnhetkinen vihollinen
                                                      tempetaisyys = floati;
                                            }
                                  }
                                  else if(vihu[j].elossa == 2) k = 0;
                                  else k = 1;
                                  j++;
                         }
                         k = 0;
                         //thn hakeutuvuus
                         if(tempkohde != -1) {
                                  floati = laskekulma(ammus[i].x, ammus[i].y, vihu[tempkohde].x, vihu[tempkohde].y); //tempkulma
                                  //floati = laskekulma(ammus[i].x, ammus[i].y, 400, 300); //tm oli testaamaan
                                            if(hakeutuvuuslevu != 0 && hakeutuvuuslevu != 5) {
                                                       if(ammus[i].suunta < floati) { //       vvv muuta nit kertoimia sopiviksi
                                                               if(floati - ammus[i].suunta < 0.0015 * hakeutuvuuslevu) ammus[i].suunta = floati;
                                                               else ammus[i].suunta = ammus[i].suunta + 0.0015 * hakeutuvuuslevu;
                                                       }
                                                       else {
                                                               if(ammus[i].suunta - floati < 0.0015 * hakeutuvuuslevu) ammus[i].suunta = floati;
                                                               else ammus[i].suunta = ammus[i].suunta - 0.0015 * hakeutuvuuslevu;
                                                       }
                                            }
                                            else if(hakeutuvuuslevu == 4){
                                                       if(ammus[i].suunta < floati) {
                                                               if(floati - ammus[i].suunta < 0.02) ammus[i].suunta = floati;
                                                               else ammus[i].suunta = ammus[i].suunta + 0.02;
                                                       }
                                                       else {
                                                               if(ammus[i].suunta - floati < 0.02) ammus[i].suunta = floati;
                                                               else ammus[i].suunta = ammus[i].suunta - 0.02;
                                                       }
                                            }
                                            else if(hakeutuvuuslevu == 5) ammus[i].suunta = floati;
                                            
                                  if(ammus[i].suunta < 0.1) ammus[i].suunta = 0.1;           //selitys tlle ammuksen luonnissa
                                  if(ammus[i].suunta > PI - 0.1) ammus[i].suunta = PI - 0.1;
                         }
              }
              else if(ammus[i].elossa == 2) k = 0;
              else k = 1;
              i++;
     }
     
              //Trmys: vihu - vihu
     i = 0; k = 0;
     while(!k && i < vihumax) {
              if(vihu[i].elossa == 1) {
                        j = i + 1;
                        k = 0;
                        while(!k && j < vihumax) {
                                 if(vihu[j].elossa == 1) {
                                           //molemmat vihulaiset ovat olemassa
                                           //testataan osuvatko ne toisiinsa
                                           if(laskeetaisyys(vihu[i].x, vihu[i].y, vihu[j].x, vihu[j].y) < (vihu[i].koko + vihu[j].koko - 2) * vihukokokerroin / 2 + vihuminkoko) {
                                                            floati = laskekulma(vihu[i].x, vihu[i].y, vihu[j].x, vihu[j].y);
                                                            //musta vihu ja pkki eivt liiku
                                                            if(vihu[i].tyyppi != 4 && vihu[i].tyyppi != 7) {
                                                                              vihu[i].nopeusy+= sin(floati) * 0.03;
                                                                              vihu[i].nopeusx-= cos(floati) * 0.05;
                                                            }
                                                            if(vihu[j].tyyppi != 4 && vihu[j].tyyppi != 7) {
                                                                              vihu[j].nopeusy-= sin(floati) * 0.03;
                                                                              vihu[j].nopeusx+= cos(floati) * 0.05;
                                                            }
                                           }
                                 }
                                 else if(vihu[j].elossa == 2) k = 0;
                                 else k = 1;
                                 j++;
                        }
                        k = 0;
              }
              else if(vihu[i].elossa == 2) k = 0;
              else k = 1;
              i++;
     }
     
              //korjataan vahingon ja nopeuden arvot
     //tm voisi periaatteessa olla mys tuossa alemmassa levelitesti jutussa
     //mutta tm onkin tll, jotta saataisin mapin latauksen takia (mahdollisesti) erilaisten levujen takia muutettua nm heti oikeiksi                   (ottakaa tuosta nyt selv :/)
     //nm olisi toki voinut testata mys mapin latauksessa, mutta tll ne ovat ktevsti vain yhdess paikassa
     if(vahinkolevu == 0) vahinko = 1;
     else if(vahinkolevu == 1) vahinko = 2;
     else if(vahinkolevu == 2) vahinko = 3;
     else if(vahinkolevu == 3) vahinko = 4;
     else if(vahinkolevu == 4) vahinko = 7;
     else if(vahinkolevu == 5) vahinko = 14;
     //tm on tasoittamaan nit taitoja
     if(hakeutuvuuslevu == 5) vahinko+= 2;
     else if(hakeutuvuuslevu == 4) vahinko++;
     else if(tarkkuuslevu == 4) vahinko++;
     
     if(nopeuslevu == 0) odotusmuutos = 60.0;
     else if(nopeuslevu == 1) odotusmuutos = 37.8;
     else if(nopeuslevu == 2) odotusmuutos = 23.8;
     else if(nopeuslevu == 3) odotusmuutos = 15.0;
     else if(nopeuslevu == 4) odotusmuutos = 9.4;
     else if(nopeuslevu == 5) odotusmuutos = 5.8;
     
              //Testataan levelit
     //vahinko
     i = 0;
     if(vahinkolevu == 0 && vahinkoexpa >= levuraja[0]) i = 1;
     if(vahinkolevu == 1 && vahinkoexpa >= levuraja[1]) i = 1;
     if(vahinkolevu == 2 && vahinkoexpa >= levuraja[2]) i = 1;
     if(vahinkolevu == 3 && vahinkoexpa >= levuraja[3] && levurajoitus == 0) {
                    i = 1;
                    levutekstilaskuri = 0;
                    levuteksti = 1;
     }
     if(vahinkolevu == 4 && vahinkoexpa >= levuraja[4]) {
                    i = 1;
                    levutekstilaskuri = 0;
                    levuteksti = 5;
     }
     if(i == 1) {
                    vahinkolevu++;
                    explisays[20].elossa = 1;
                    explisays[20].x = 155;
                    explisays[20].y = 75;
                    explisays[20].luku = -1;
                    explisays[20].nopeus = -6;
                    luolevupartikkelit(75);
                    soitalevelup = true;
     }
     //tarkkuus
     i = 0;
     if(tarkkuuslevu == 0 && tarkkuusexpa >= levuraja[0]) i = 1;
     if(tarkkuuslevu == 1 && tarkkuusexpa >= levuraja[1]) i = 1;
     if(tarkkuuslevu == 2 && tarkkuusexpa >= levuraja[2]) i = 1;
     if(tarkkuuslevu == 3 && tarkkuusexpa >= levuraja[3] && levurajoitus == 0) {
                    i = 1;
                    levutekstilaskuri = 0;
                    levuteksti = 2;
     }
     if(tarkkuuslevu == 4 && tarkkuusexpa >= levuraja[4]) {
                    i = 1;
                    levutekstilaskuri = 0;
                    levuteksti = 6;
     }
     if(i == 1) {
                    tarkkuuslevu++;
                    explisays[21].elossa = 1;
                    explisays[21].x = 155;
                    explisays[21].y = 175;
                    explisays[21].luku = -1;
                    explisays[21].nopeus = -6;
                    luolevupartikkelit(175);
                    soitalevelup = true;
     }
     //nopeus
     i = 0;
     if(nopeuslevu == 0 && nopeusexpa >= levuraja[0]) i = 1;
     if(nopeuslevu == 1 && nopeusexpa >= levuraja[1]) i = 1;
     if(nopeuslevu == 2 && nopeusexpa >= levuraja[2]) i = 1;
     if(nopeuslevu == 3 && nopeusexpa >= levuraja[3] && levurajoitus == 0) {
                    i = 1;
                    levutekstilaskuri = 0;
                    levuteksti = 3;
     }
     if(nopeuslevu == 4 && nopeusexpa >= levuraja[4]) {
                    i = 1;
                    levutekstilaskuri = 0;
                    levuteksti = 7;
     }
     if(i == 1) {
                    nopeuslevu++;
                    explisays[22].elossa = 1;
                    explisays[22].x = 155;
                    explisays[22].y = 275;
                    explisays[22].luku = -1;
                    explisays[22].nopeus = -6;
                    luolevupartikkelit(275);
                    soitalevelup = true;
     }
     //hakeutuvuus
     i = 0;
     if(hakeutuvuuslevu == 0 && hakeutuvuusexpa >= levuraja[0]) i = 1;
     if(hakeutuvuuslevu == 1 && hakeutuvuusexpa >= levuraja[1]) i = 1;
     if(hakeutuvuuslevu == 2 && hakeutuvuusexpa >= levuraja[2]) i = 1;
     if(hakeutuvuuslevu == 3 && hakeutuvuusexpa >= levuraja[3] && levurajoitus == 0) {
                    i = 1;
                    levutekstilaskuri = 0;
                    levuteksti = 4;
     }
     if(hakeutuvuuslevu == 4 && hakeutuvuusexpa >= levuraja[4]) {
                    i = 1;
                    levutekstilaskuri = 0;
                    levuteksti = 8;
     }
     if(i == 1) {
                    hakeutuvuuslevu++;
                    explisays[23].elossa = 1;
                    explisays[23].x = 155;
                    explisays[23].y = 375;
                    explisays[23].luku = -1;
                    explisays[23].nopeus = -6;
                    luolevupartikkelit(375);
                    soitalevelup = true;
     }
     //levurajoitus1
     if(levurajoitus == 0) {
                     if(vahinkolevu > 3 || tarkkuuslevu > 3 || nopeuslevu > 3 || hakeutuvuuslevu > 3) levurajoitus = 1;
     }
     //levurajoitus2
     if(levurajoitus == 1 && vahinkolevu >= 3 && tarkkuuslevu >= 3 && nopeuslevu >= 3 && hakeutuvuuslevu >= 3) {
                     if(vahinkolevu == 5 || tarkkuuslevu == 5 || nopeuslevu == 5 || hakeutuvuuslevu == 5) levurajoitus = 2;
     }
     //peruslevu
     i = 0;
     if(levu == 0 && expa >= peruslevuraja[0]) i = 1;
     if(levu == 1 && expa >= peruslevuraja[1]) i = 1;
     if(levu == 2 && expa >= peruslevuraja[2]) i = 1;
     if(levu == 3 && expa >= peruslevuraja[3]) i = 1;
     if(levu == 4 && expa >= peruslevuraja[4]) i = 1;
     if(levu == 5 && expa >= peruslevuraja[5]) i = 1;
     if(levu == 6 && expa >= peruslevuraja[6]) i = 1;
     if(levu == 7 && expa >= peruslevuraja[7]) i = 1;
     if(levu == 8 && expa >= peruslevuraja[8]) i = 1;
     if(i == 1) {
                    levu++;
                    explisays[24].elossa = 1;
                    explisays[24].x = 155;
                    explisays[24].y = 475;
                    explisays[24].luku = -1;
                    explisays[24].nopeus = -6;
                    luolevupartikkelit(475);
                    soitalevelup = true;
                    if(levurajoitus != 2) {
                                    menekauppaan = true;
                                    piirtokohta = tempruutu; //piirretnkin kaikki tempruudulle, kun mennn kauppaan
                    }
     }
     
     
     
              //           PIIRRETN KAIKKI
     
     //piirretn tausta
     piirrakuva2(tausta, 150, 0);
     //piirretn mys alatausta ennen muita
     piirrakuva2(taustaala, 150, 550);
     if(!gameover) piirrakuva2(taustaala2, 150, 545);
     else {
          piirrakuva2(gameoverrikki, gameoverkohta - 50, 545);
          piirrakuva2(taustaala2, gameoverkohta - 550, 545);
          piirrakuva2(taustaala2, gameoverkohta + 50, 545);
     }
     
                             //         thn peliareena
     //vihu
     i = 0; j = 0;
     while(!j && i < vihumax) {
              if(vihu[i].elossa == 1) {
                                if(vihu[i].tyyppi == 3) piirrakuva(vihukuvakeltainen[int(vihu[i].koko - 1)][vihu[i].kuvasuunta], vihu[i].x, vihu[i].y); //keltainen vihu
                                else if(vihu[i].tyyppi == 4) piirrakuva(vihukuvamusta, vihu[i].x, vihu[i].y); //musta vihu
                                else if(vihu[i].tyyppi == 7) piirraanimoitukuva(vihukuva7, vihu[i].x, vihu[i].y, 120, 120, (int)floor(float(aikalaskuri % 60) / 5.0)); //pkki
                                else if(vihu[i].tyyppi == 5) { //nopea vihu
                                     if(vihu[i].nopeusy > 7 || vihu[i].nopeusy < -7) piirrakuva(vihukuvanopea[4], vihu[i].x, vihu[i].y);
                                     else piirrakuva(vihukuvanopea[abs(int(round(vihu[i].nopeusy / 1.75)))], vihu[i].x, vihu[i].y);
                                }
                                else if(vihu[i].tyyppi == 6) piirrakuva(vihukuva[3][int(vihu[i].koko - 1)], vihu[i].x, vihu[i].y); //violetti vihu
                                else piirrakuva(vihukuva[vihu[i].tyyppi][int(vihu[i].koko - 1)], vihu[i].x, vihu[i].y);
                                //debug - spawnerin nimi
                                if(mapdebug != 0) {
                                            if(vihu[i].y - ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko) / 2 - 12 < 0) piirrateksti(vihu[i].nimi, vihu[i].x - ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko) / 2, 0, 2, 0);
                                            else piirrateksti(vihu[i].nimi, vihu[i].x - ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko) / 2, vihu[i].y - ((vihu[i].koko - 1) * vihukokokerroin + vihuminkoko) / 2 - 12, 2, 0);
                                }
              }
              else if(vihu[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }
     //vihu splatteremitter
     i = 0; j = 0;
     while(!j && i < vihusplatteremittermax) {
              if(vihusplatteremitter[i].elossa == 1) {
                                        if(vihusplatteremitter[i].tyyppi == 4) piirrakuva(vihukuollutkuvamusta[int(vihusplatteremitter[i].suunta)], vihusplatteremitter[i].x, vihusplatteremitter[i].y);
                                        else if(vihusplatteremitter[i].tyyppi == 5) piirrakuva(vihukuollutkuvanopea[int(vihusplatteremitter[i].suunta)], vihusplatteremitter[i].x, vihusplatteremitter[i].y);
              }
              else if(vihusplatteremitter[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }
     //vihu splatter
     if(showparticles != 0) {
     i = 0; j = 0;
     while(!j && i < vihusplattermax) {
              if(vihusplatter[i].elossa == 1) {
                                        if(vihusplatter[i].tyyppi == 4) piirrakuva(splatterkuvamusta[int(4 - ceil(vihusplatter[i].frame / 6))][int(floor(vihusplatter[i].suunta / 12))], vihusplatter[i].x, vihusplatter[i].y);
                                        else if(vihusplatter[i].tyyppi == 5) piirrakuva(splatterkuvanopea[int(4 - ceil(vihusplatter[i].frame / 6))][int(floor(vihusplatter[i].suunta / 12))], vihusplatter[i].x, vihusplatter[i].y);
                                        else if(vihusplatter[i].tyyppi == 6) piirrakuva(splatterkuva[4][int(vihusplatter[i].koko - 1)][int(4 - ceil(vihusplatter[i].frame / 6))][int(floor(vihusplatter[i].suunta / 12))], vihusplatter[i].x, vihusplatter[i].y);
                                        else piirrakuva(splatterkuva[vihusplatter[i].tyyppi][int(vihusplatter[i].koko - 1)][int(4 - ceil(vihusplatter[i].frame / 6))][int(floor(vihusplatter[i].suunta / 12))], vihusplatter[i].x, vihusplatter[i].y);
              }
              else if(vihusplatter[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }}
     //ammus
     i = 0; j = 0;
     while(!j && i < ammusmax) {
              if(ammus[i].elossa == 1) {
                         if(ammus[i].efekti >= 0) {
                                    if(ammus[i].crit == true) piirrakuva(efektikuvapunainen[int(ceil(ammus[i].efekti / 4))], ammus[i].suuntakohtax, ammus[i].suuntakohtay);
                                    else piirrakuva(efektikuvakeltainen[int(ceil(ammus[i].efekti / 4))], ammus[i].suuntakohtax, ammus[i].suuntakohtay);
                         }
                         if(ammus[i].crit == true) piirrakuva(panoscrit[int(round(ammus[i].suunta / PI * 45))], ammus[i].x + cos(ammus[i].suunta) * 10, ammus[i].y - sin(ammus[i].suunta) * 10);
                         else piirrakuva(panos[int(round(ammus[i].suunta / PI * 45))], ammus[i].x + cos(ammus[i].suunta) * 10, ammus[i].y - sin(ammus[i].suunta) * 10); //ammukset piirretn hieman edelle
              }
              else if(ammus[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }
     //partikkeli
     if(showparticles != 0) {
     i = 0; j = 0;
     while(!j && i < partikkelimax) {
              if(partikkeli[i].elossa == 1) {
                                        if(partikkeli[i].tyyppi == 1) piirrakuva(partikkeli1[2 - int(round(partikkeli[i].nopeus * 1.6))], partikkeli[i].x, partikkeli[i].y);
                                        else if(partikkeli[i].tyyppi == 2) piirrakuva(partikkeli2[4 - int(round(sqrt(partikkeli[i].nopeus) * 0.79))], partikkeli[i].x, partikkeli[i].y);
                                        else if(partikkeli[i].tyyppi == 3) piirraanimoitukuva(partikkeli3, partikkeli[i].x, partikkeli[i].y, 5, 5, 2 - int(round(partikkeli[i].nopeus * 1.6)));
              }
              else if(partikkeli[i].elossa == 2) j = 0;
              else j = 1;
              i++;
     }}
                             //         peliareena loppuu
     
              //HUD
     //piirretn tykki
     piirrakuva(tykkialusta, 400, 550);
     if(tykkitulilaskuri > 0) piirrakuva(tykkituli[int(3 - ceil(tykkitulilaskuri / 3))][tykkitulikuva][int(round(tykkitulisuunta / PI * 45))], 400 + cos(tykkitulisuunta) * 52, 550 - sin(tykkitulisuunta) * 52);
     piirrakuva(tykki[int(round(tarkhiirikulma / PI * 45))], 400, 550);
     //tarkkuus viivat
     if(sightsetting != 2) {
                     piirraviiva(400,550,tarkviivavx,tarkviivavy);
                     if(tarkkuusarvo != 0) piirraviiva(400,550,tarkviivaox,tarkviivaoy);
     }
     //piiretn thtin
     if(sightsetting != 1) {
                     if(tarkkuusarvo != 0) piirrakuva(tahtain[tahtainkoko], tarkhiirix, tarkhiiriy);
                     else {
                          if(crittahtainkuva < 13) piirraanimoitukuva(crittahtain, tarkhiirix, tarkhiiriy, 20, 20, int(ceil(crittahtainkuva / 3)) - 1);
                          else piirraanimoitukuva(crittahtain, tarkhiirix, tarkhiiriy, 20, 20, int(ceil(crittahtainkuva / 3)) % 4 + 4);
                     }
     }
     //piirretn explisysnumerot
     for(i=0;i<25;i++) {
              if(explisays[i].elossa == 1) piirraexplisays(explisays[i].luku, explisays[i].x, explisays[i].y);
     }
     //piirretn tervehdys
     if(aikalaskuri < 200) {
                    if(strcmp(tervehdys, "secret") == 0) { //mist mist lainattu?            hmm...
                                         piirrateksti("\"  Greetings Mortal,  \"", 400 + 0.0004 * pow((aikalaskuri - 100), 3) + aikalaskuri - 100, 159, 1, 1);
                                         piirrateksti("are you ready to die?", 400 + 0.0004 * pow((aikalaskuri - 100), 3) + aikalaskuri - 100, 209, 1, 1);
                    }
                    else if(strcmp(tervehdys, "tutorial") == 0) piirrateksti("Welcome to Evolute", 400 + 0.003 * pow((aikalaskuri - 60), 3) + aikalaskuri - 60, 159, 1, 1);
                    else if(strcmp(tervehdys, "boss") == 0) piirrateksti("Here comes the boss!", 400 + 0.003 * pow((aikalaskuri - 60), 3) + aikalaskuri - 60, 159, 1, 1);
                    else piirrateksti(tervehdys, 400 + 0.003 * pow((aikalaskuri - 60), 3) + aikalaskuri - 60, 151, 0, 1);
     }
     //piirretn stagen lopputeksti
     if(peliloppulaskuri != 0) piirrateksti("Completed!", 400 + 0.0004 * pow((peliloppulaskuri - 120), 3) + peliloppulaskuri - 120, 151, 0, 1);
     //piirretn ilmoitukset 4:st ja 5:st levuista
     if(levutekstilaskuri < 200) {
                    switch(levuteksti) {
                           case 1: piirrateksti("Super damage reached!", 400 + 0.0004 * pow((levutekstilaskuri - 100), 3) + levutekstilaskuri - 100, 159, 1, 1); break;
                           case 2: piirrateksti("Super accuracy reached!", 400 + 0.0004 * pow((levutekstilaskuri - 100), 3) + levutekstilaskuri - 100, 159, 1, 1); break;
                           case 3: piirrateksti("Super speed reached!", 400 + 0.0004 * pow((levutekstilaskuri - 100), 3) + levutekstilaskuri - 100, 159, 1, 1); break;
                           case 4: piirrateksti("Super homing reached!", 400 + 0.0004 * pow((levutekstilaskuri - 100), 3) + levutekstilaskuri - 100, 159, 1, 1); break;
                           case 5: piirrateksti("Ultimate damage reached!", 400 + 0.0004 * pow((levutekstilaskuri - 100), 3) + levutekstilaskuri - 100, 159, 1, 1); break;
                           case 6: piirrateksti("Ultimate accuracy reached!", 400 + 0.0004 * pow((levutekstilaskuri - 100), 3) + levutekstilaskuri - 100, 159, 1, 1); break;
                           case 7: piirrateksti("Ultimate speed reached!", 400 + 0.0004 * pow((levutekstilaskuri - 100), 3) + levutekstilaskuri - 100, 159, 1, 1); break;
                           case 8: piirrateksti("Ultimate homing reached!", 400 + 0.0004 * pow((levutekstilaskuri - 100), 3) + levutekstilaskuri - 100, 159, 1, 1); break;
                    }
     }
              //Taustat
     //piirretn taustat
     piirrakuva2(taustavasen, 0, 0);
     piirrakuva2(taustaoikea, 650, 0);
     piirrakuva2(taustavasen2, 150, 0);
     piirrakuva2(taustaoikea2, 645, 0);
     if(valinta == 0) piirrakuva2(nappipeliexit1, 750, 0);
     else piirrakuva2(nappipeliexit2, 750, 0);
              //Vasen sivupalkki
     //piirretn levelit
     if(levurajoitus != 0 && vahinkolevu == 3) piirrakuva2(levelikuva3, 105, 55);
     else piirrakuva2(levelikuva[vahinkolevu], 105, 55);
     if(levurajoitus != 0 && tarkkuuslevu == 3) piirrakuva2(levelikuva3, 105, 155);
     else piirrakuva2(levelikuva[tarkkuuslevu], 105, 155);
     if(levurajoitus != 0 && nopeuslevu == 3) piirrakuva2(levelikuva3, 105, 255);
     else piirrakuva2(levelikuva[nopeuslevu], 105, 255);
     if(levurajoitus != 0 && hakeutuvuuslevu == 3) piirrakuva2(levelikuva3, 105, 355);
     else piirrakuva2(levelikuva[hakeutuvuuslevu], 105, 355);
     if(levu <= 3) piirrakuva2(levelikuva[levu], 105, 455);
     else piirrakuva2(peruslevelikuva[levu - 4], 105, 455);
     //piirretn exppalkit
     if(vahinkolevu == 5 || showexpgoals == 0) piirrakuva2(exppalkkityhja, 15, 110);
     else if(levurajoitus != 0 && vahinkolevu == 3) piirrakuva2(exppalkkityhja, 15, 110);
     else piirrakuva2(exppalkki[vahinkolevu], 15, 110);
     if(tarkkuuslevu == 5 || showexpgoals == 0) piirrakuva2(exppalkkityhja, 15, 210);
     else if(levurajoitus != 0 && tarkkuuslevu == 3) piirrakuva2(exppalkkityhja, 15, 210);
     else piirrakuva2(exppalkki[tarkkuuslevu], 15, 210);
     if(nopeuslevu == 5 || showexpgoals == 0) piirrakuva2(exppalkkityhja, 15, 310);
     else if(levurajoitus != 0 && nopeuslevu == 3) piirrakuva2(exppalkkityhja, 15, 310);
     else piirrakuva2(exppalkki[nopeuslevu], 15, 310);
     if(hakeutuvuuslevu == 5 || showexpgoals == 0) piirrakuva2(exppalkkityhja, 15, 410);
     else if(levurajoitus != 0 && hakeutuvuuslevu == 3) piirrakuva2(exppalkkityhja, 15, 410);
     else piirrakuva2(exppalkki[hakeutuvuuslevu], 15, 410);
     if(showexpgoals == 0) piirrakuva2(exppalkkityhja, 15, 510);
     else piirrakuva2(exppalkki[levu + 5], 15, 510);
     //piirretn expat
     piirraexpluku(vahinkoexpa, 1);
     piirraexpluku(tarkkuusexpa, 2);
     piirraexpluku(nopeusexpa, 3);
     piirraexpluku(hakeutuvuusexpa, 4);
     piirraexpluku(expa, 5);
     //piirretn levelipalkit
     if(vahinkolevu != 5) {
                    if(levurajoitus != 0 && vahinkolevu == 3) { }
                    else if(vahinkolevu == 0) piirrakuva2(levelipalkki[int(floor(vahinkoexpa / float(levuraja[0]) * 130))], 15, 110);
                    else piirrakuva2(levelipalkki[int(floor((vahinkoexpa - float(levuraja[vahinkolevu - 1])) / (float(levuraja[vahinkolevu]) - float(levuraja[vahinkolevu - 1])) * 130))], 15, 110);
     }
     if(tarkkuuslevu != 5) {
                    if(levurajoitus != 0 && tarkkuuslevu == 3) { }
                    else if(tarkkuuslevu == 0) piirrakuva2(levelipalkki[int(floor(tarkkuusexpa / float(levuraja[0]) * 130))], 15, 210);
                    else piirrakuva2(levelipalkki[int(floor((tarkkuusexpa - float(levuraja[tarkkuuslevu - 1])) / (float(levuraja[tarkkuuslevu]) - float(levuraja[tarkkuuslevu - 1])) * 130))], 15, 210);
     }
     if(nopeuslevu != 5) {
                    if(levurajoitus != 0 && nopeuslevu == 3) { }
                    else if(nopeuslevu == 0) piirrakuva2(levelipalkki[int(floor(nopeusexpa / float(levuraja[0]) * 130))], 15, 310);
                    else piirrakuva2(levelipalkki[int(floor((nopeusexpa - float(levuraja[nopeuslevu - 1])) / (float(levuraja[nopeuslevu]) - float(levuraja[nopeuslevu - 1])) * 130))], 15, 310);
     }
     if(hakeutuvuuslevu != 5) {
                    if(levurajoitus != 0 && hakeutuvuuslevu == 3) { }
                    else if(hakeutuvuuslevu == 0) piirrakuva2(levelipalkki[int(floor(hakeutuvuusexpa / float(levuraja[0]) * 130))], 15, 410);
                    else piirrakuva2(levelipalkki[int(floor((hakeutuvuusexpa - float(levuraja[hakeutuvuuslevu - 1])) / (float(levuraja[hakeutuvuuslevu]) - float(levuraja[hakeutuvuuslevu - 1])) * 130))], 15, 410);
     }
     if(levu != 9) {
                    if(levu == 0) piirrakuva2(levelipalkki[int(floor(expa / float(peruslevuraja[0]) * 130))], 15, 510);
                    else piirrakuva2(levelipalkki[int(floor((expa - float(peruslevuraja[levu - 1])) / (float(peruslevuraja[levu]) - float(peruslevuraja[levu - 1])) * 130))], 15, 510);
     }
              //Oikea sivupalkki
     //piirretn pisteet
     piirraexpluku(pisteet, 6);
     //piirretn fps
     if(showfpseverywhere == 1 || showfpseverywhere == 2) {
                          piirrakuva2(fpslaatikko, 655, 160);
                          piirraexpluku(fps, 7);
     }
     //piirretn aika
     if(onsurvival) piirrakuva2(aikasurvival, 703, 218);
     else if(boss) piirrakuva2(aikaboss, 703, 218);
     else {
                  piirrakuva2(aikajakaja, 726, 221);
                  if(peliaika <= 0) {
                              piirraexpluku(0, 8);
                              piirraexpluku(0, 9);
                  }
                  else {
                              piirraexpluku(int(floor(float(peliaika + 39) / 2400.0)), 8);
                              piirraexpluku(int(ceil(float(peliaika - floor(float(peliaika + 39) / 2400.0) * 2400) / 40.0)), 9);
                  }
     }
     //piirretn elmt
     if(onelamat) {
                  piirrakuva2(elamatkuva, 655, 267);
                  for(i=elamalkm;i>0;i--) piirrakuva2(elamakuva, 698 + 20 * i, 268);
     }
     //piirretn kartan nimi
     piirrateksti(nykyinenkartta, 790, 578, 2, 2);
     
     //kursori - aivan pllimmiseksi
     piirrakuva(pelitahtain, hiirix, hiiriy);
     
     //tutorial thn, jotta voidaan piirt sen tekstit
     if(ontutorial) {
                    short int tutorialtapahtuma = tutorial(vihu[0].elossa);
                    if(tutorialtapahtuma == 1) { //spawnataan vihu, jos palauttaa true
                                   vihu[0].elossa = 1;
                                   vihu[0].arvo = 1;
                                   vihu[0].koko = 2;
                                   vihu[0].x = rand() % 480 + 160;
                                   vihu[0].y = 0 - (vihukokokerroin + vihuminkoko) / 2;
                                   vihu[0].vihunopeus = 0.25;
                                   vihu[0].nopeusy = 0.25;
                                   vihu[0].nopeusx = 0;
                                   vihu[0].kuvasuunta = rand() % 10;
                                   vihu[0].vihuenergia = 1;
                                   vihu[0].energia = 1;
                                   vihu[0].tyyppi = 0;
                                   vihu[0].lopussa = false;
                    }
                    else if(tutorialtapahtuma == 2) pois = true;
     }
     
     //alkufade viel plimmisemmksi
     if(aikalaskuri < 40) {
                    SDL_SetAlpha(valkoinenfade, SDL_SRCALPHA, int(round(255 - aikalaskuri * 6.375)));
                    piirrakuva2(valkoinenfade, 0, 0);
     }
     //stagen loppufade
     if(peliloppulaskuri > 160) {
                    SDL_SetAlpha(valkoinenfade, SDL_SRCALPHA, int(round(peliloppulaskuri * 3.1875 - 510)));
                    piirrakuva2(valkoinenfade, 0, 0);
                    if(peliloppulaskuri == 240) { //poistutaan
                                        pois = true;
                                        menuvalinta = 106;
                                        voitto = true;
                    }
     }
     
     //debug
     if(mapdebug != 0) piirrafloatluku(int(floor(aikalaskuri / 40)), 10, 10);
     
     //tm tappaa fps:n, ei tehdkkn nin...
                              //siirretn tempruutu ruutuun
                              //SDL_BlitSurface(tempruutu, NULL, ruutu, NULL);
     //ja flipataan
     SDL_Flip(ruutu);
     
     
              //LOPUSSA TEHTVT ASIAT
     
     tarkhiiriprewx = tarkhiirix;
     tarkhiiriprewy = tarkhiiriy;
     tarkhiiriprewkulma = tarkhiirikulma;
     if(hiiriekanappi) hiiriprewekanappi = true;
     else hiiriprewekanappi = false;
     prewvalinta = valinta;
     
     if(hoidatapahtumat()) pois = true;
     laskefps();
     
     //mennn kauppaa
     if(menekauppaan && !gameover) {
            menekauppaan = false;
            i = kauppa();
            if(i == 1) vahinkoexpa+= 1000;
            if(i == 2) tarkkuusexpa+= 1000;
            if(i == 3) nopeusexpa+= 1000;
            if(i == 4) hakeutuvuusexpa+= 1000;
            if(i == 5) {
                 soitalevelup = false;
                 pois = true;
            }
            if(i == 6) {
                 soitalevelup = false;
                 pois = true;
                 menuvalinta = -1;
            }
            crittarkkuus = true; //kaupasta saa tarkan thtimen :)
     }
     //soitetaan levelup-ni
     if(soitalevelup && !alasoitalevelup) {
                      soitaaani(levelup);
                      soitalevelup = false;
                      alasoitalevelup = true;
     }
     else {
                      soitalevelup = false;
                      alasoitalevelup = false;
     }
     //mennn escmenuun
     if(meneescmenuun && !gameover) {
            meneescmenuun = false;
            vapautaesc = false; //lukitaan esc-nappi
            if(escmenu()) { //poistutaan menuun
                 pois = true;
                 menuvalinta = -1;
            }
            if(kokonaanpois) { //poistutaan kokonaan
                 pois = true;
                 menuvalinta = -1;
                 kokonaanpois = true;
            }
     }
     //game over
     if(gameover) {
            pois = true;
            if(onsurvival) menuvalinta = 101;
            else menuvalinta = 105;
     }
     
     //lopullisen peliloopin whilen sulku
     }

//pelilooppi loppuu
}

//luodaan partikkelit, jotka ilmestyvt levunsaannin yhteydess
void luolevupartikkelit(const short int kohta) {
     for(int a=0;a<20;a++) { //luodaan 20
                     i = 0; j = 0;
                     while(!j && i < partikkelimax) {
                              if(partikkeli[i].elossa == 0 || partikkeli[i].elossa == 2) {
                                              partikkeli[i].elossa = 1;
                                              partikkeli[i].tyyppi = 2;
                                              partikkeli[i].x = 135;
                                              partikkeli[i].y = kohta;
                                              floati = rand() % 100;
                                              partikkeli[i].nopeus = floati * 0.3 + 2;
                                              partikkeli[i].kitka = 0.94;
                                              partikkeli[i].suunta = rand() % 40 - 20;
                                              j = 1;
                              }
                              i++;
                     }
     }
}
