/*


    Evolute version 0.7
    Copyright (C) 2010 Antti Vainio

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


*/

//          piirtofunktiot.cpp

#include <math.h>
#include "global.hpp"

//piirt kuvan ruudulle - kuvan keskipiste menee kohtaan
void piirrakuva(SDL_Surface *tempkuva, const float kohtax, const float kohtay) {
     SDL_Rect tempkuvakohta;
     tempkuvakohta.x = int(round(kohtax - tempkuva->w / 2));
     tempkuvakohta.y = int(round(kohtay - tempkuva->h / 2));
     SDL_BlitSurface(tempkuva, NULL, piirtokohta, &tempkuvakohta);
}

//piirt kuvan ruudulle - kuvan vasen ylkulma menee kohtaan
void piirrakuva2(SDL_Surface *tempkuva, const float kohtax, const float kohtay) {
     SDL_Rect tempkuvakohta;
     tempkuvakohta.x = int(round(kohtax));
     tempkuvakohta.y = int(round(kohtay));
     SDL_BlitSurface(tempkuva, NULL, piirtokohta, &tempkuvakohta);
}

//piirt kuvan kiinni taustaan - kuvan keskipiste menee kohtaan
void piirrakuvataustaan(SDL_Surface *tempkuva, const float kohtax, const float kohtay) {
     SDL_Rect tempkuvakohta;
     tempkuvakohta.x = int(round(kohtax - 150 - tempkuva->w / 2));
     tempkuvakohta.y = int(round(kohtay - tempkuva->h / 2));
     SDL_BlitSurface(tempkuva, NULL, tausta, &tempkuvakohta);
}

//piirt animoidun kuvan ruudulle - kuvan keskipiste menee kohtaan
void piirraanimoitukuva(SDL_Surface *tempkuva, const float kohtax, const float kohtay, const short int kuvanleveys, const short int kuvankorkeus, const short int kuva) {
     SDL_Rect tempkuvakohta;
     SDL_Rect kuvaalue;
     tempkuvakohta.x = int(round(kohtax - kuvanleveys / 2));
     tempkuvakohta.y = int(round(kohtay - kuvankorkeus / 2));
     kuvaalue.w = kuvanleveys;
     kuvaalue.h = kuvankorkeus;
     kuvaalue.x = 0;
     kuvaalue.y = kuvankorkeus * kuva;
     SDL_BlitSurface(tempkuva, &kuvaalue, piirtokohta, &tempkuvakohta);
}

//piirt animoidun kuvan kiinni taustaan - kuvan keskipiste menee kohtaan
void piirraanimoitukuvataustaan(SDL_Surface *tempkuva, const float kohtax, const float kohtay, const short int kuvanleveys, const short int kuvankorkeus, const short int kuva) {
     SDL_Rect tempkuvakohta;
     SDL_Rect kuvaalue;
     tempkuvakohta.x = int(round(kohtax - 150 - kuvanleveys / 2));
     tempkuvakohta.y = int(round(kohtay - kuvankorkeus / 2));
     kuvaalue.w = kuvanleveys;
     kuvaalue.h = kuvankorkeus;
     kuvaalue.x = 0;
     kuvaalue.y = kuvankorkeus * kuva;
     SDL_BlitSurface(tempkuva, &kuvaalue, tausta, &tempkuvakohta);
}

//piirretn viiva pisteest a pisteeseen b
void piirraviiva(const float alkux, const float alkuy, const float loppux, const float loppuy) {
     viivavari = SDL_MapRGB(piirtokohta->format, gfxviivavari[0], gfxviivavari[1], gfxviivavari[2]);
     Uint32 *viivapiste;
     
     //lasketaan viivan pituus - pisteiden mr
     int viivapituus = int(ceil(laskeetaisyys(alkux, alkuy, loppux, loppuy)));
     
     //lasketaan suunta radiaaneina
     float viivasuunta = laskekulma(alkux, alkuy, loppux, loppuy);
     
     //lasketaan yhden pisteen pituus
     float viivacosx = cos(viivasuunta);
     float viivasiny = sin(viivasuunta);
     
     //piirretn
     for(int i=viivapituus;i>0;i--) {
             int viivakohtax = int(round(alkux + viivacosx * i));
             int viivakohtay = int(round(alkuy - viivasiny * i));
             //testataan, ett piste ei ole ruudun ulkopuolella
             if(viivakohtax >= 0 && viivakohtay >= 0 && viivakohtax < 800 && viivakohtay < 600) {
                            viivapiste = (Uint32*)piirtokohta->pixels + viivakohtay * piirtokohta->pitch / 4 + viivakohtax;
                            *viivapiste = viivavari;
             }
     }
}
